/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.asteroid;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import org.destinationsol.game.FarObject;
import org.destinationsol.game.RemoveController;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;

public class FarAsteroid
implements FarObject {
    private final Vector2 position;
    private final float angle;
    private final RemoveController removeController;
    private final float size;
    private final Vector2 velocity;
    private final float rotationSpeed;
    private final TextureAtlas.AtlasRegion texture;

    public FarAsteroid(TextureAtlas.AtlasRegion texture, Vector2 position, float angle, RemoveController removeController, float size, Vector2 velocity, float rotationSpeed) {
        this.texture = texture;
        this.position = position;
        this.angle = angle;
        this.removeController = removeController;
        this.size = size;
        this.velocity = velocity;
        this.rotationSpeed = rotationSpeed;
    }

    @Override
    public boolean shouldBeRemoved(SolGame game) {
        return this.removeController != null && this.removeController.shouldRemove(this.position);
    }

    @Override
    public SolObject toObject(SolGame game) {
        return game.getAsteroidBuilder().build(game, this.position, this.texture, this.size, this.angle, this.rotationSpeed, this.velocity, this.removeController);
    }

    @Override
    public void update(SolGame game) {
    }

    @Override
    public float getRadius() {
        return this.size;
    }

    @Override
    public Vector2 getPosition() {
        return this.position;
    }

    @Override
    public String toDebugString() {
        return null;
    }

    @Override
    public boolean hasBody() {
        return true;
    }
}

