/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.chunk;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.Optional;
import org.destinationsol.assets.Assets;
import org.destinationsol.common.SolColor;
import org.destinationsol.common.SolMath;
import org.destinationsol.common.SolRandom;
import org.destinationsol.game.DebugOptions;
import org.destinationsol.game.Faction;
import org.destinationsol.game.RemoveController;
import org.destinationsol.game.ShipConfig;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.asteroid.FarAsteroid;
import org.destinationsol.game.chunk.SpaceEnvConfig;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.drawables.DrawableLevel;
import org.destinationsol.game.drawables.FarDrawable;
import org.destinationsol.game.drawables.RectSprite;
import org.destinationsol.game.drawables.SpriteManager;
import org.destinationsol.game.input.AiPilot;
import org.destinationsol.game.input.StillGuard;
import org.destinationsol.game.maze.Maze;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.planet.PlanetManager;
import org.destinationsol.game.planet.SolSystem;
import org.destinationsol.game.planet.SysConfig;
import org.destinationsol.game.planet.SystemBelt;
import org.destinationsol.game.ship.FarShip;
import org.destinationsol.game.ship.hulls.HullConfig;

public class ChunkFiller {
    private static final float DUST_DENSITY = 0.2f;
    private static final float ASTEROID_DENSITY = 0.008f;
    private static final float MIN_SYS_A_SZ = 0.5f;
    private static final float MAX_SYS_A_SZ = 1.2f;
    private static final float MIN_BELT_A_SZ = 0.4f;
    private static final float MAX_BELT_A_SZ = 2.4f;
    private static final float JUNK_MAX_SZ = 0.3f;
    private static final float JUNK_MAX_ROT_SPD = 45.0f;
    private static final float JUNK_MAX_SPD_LEN = 0.3f;
    private static final float FAR_JUNK_MAX_SZ = 2.0f;
    private static final float FAR_JUNK_MAX_ROT_SPD = 10.0f;
    private static final float ENEMY_MAX_SPD = 0.3f;
    private static final float ENEMY_MAX_ROT_SPD = 15.0f;
    private static final float DUST_SZ = 0.02f;
    private static final float MAX_A_SPD = 0.2f;
    private static final float BELT_A_DENSITY = 0.04f;
    private static final float MAZE_ZONE_BORDER = 20.0f;
    private final TextureAtlas.AtlasRegion dustTexture = Assets.getAtlasRegion("engine:spaceDecorationDust");

    public void fill(SolGame game, Vector2 chunk, RemoveController removeController, boolean fillFarBackground) {
        if (DebugOptions.NO_OBJS) {
            return;
        }
        Vector2 chunkCenter = new Vector2(chunk);
        chunkCenter.scl(20.0f);
        chunkCenter.add(10.0f, 10.0f);
        float[] densityMultiplier = new float[]{1.0f};
        Optional<SpaceEnvConfig> config = this.getConfig(game, chunkCenter, densityMultiplier, removeController, fillFarBackground);
        if (fillFarBackground) {
            config.ifPresent(spaceEnvConfig -> {
                this.fillFarJunk(game, chunkCenter, removeController, DrawableLevel.FAR_DECO_3, (SpaceEnvConfig)spaceEnvConfig, densityMultiplier[0]);
                this.fillFarJunk(game, chunkCenter, removeController, DrawableLevel.FAR_DECO_1, (SpaceEnvConfig)spaceEnvConfig, densityMultiplier[0]);
                this.fillFarJunk(game, chunkCenter, removeController, DrawableLevel.FAR_DECO_2, (SpaceEnvConfig)spaceEnvConfig, densityMultiplier[0]);
            });
        } else {
            this.fillDust(game, chunkCenter, removeController);
            config.ifPresent(spaceEnvConfig -> this.fillJunk(game, removeController, (SpaceEnvConfig)spaceEnvConfig, chunkCenter));
        }
    }

    private Optional<SpaceEnvConfig> getConfig(SolGame game, Vector2 chunkCenter, float[] densityMultiplier, RemoveController removeController, boolean fillFarBackground) {
        float zoneRadius;
        PlanetManager planetManager = game.getPlanetManager();
        SolSystem system = planetManager.getNearestSystem(chunkCenter);
        float distanceToSystem = system.getPosition().dst(chunkCenter);
        if (distanceToSystem < system.getRadius()) {
            if (distanceToSystem < 78.0f) {
                return Optional.empty();
            }
            for (SystemBelt belt : system.getBelts()) {
                if (!belt.contains(chunkCenter)) continue;
                if (!fillFarBackground) {
                    this.fillAsteroids(game, removeController, true, chunkCenter);
                }
                SysConfig beltConfig = belt.getConfig();
                for (ShipConfig enemyConfig : beltConfig.tempEnemies) {
                    if (fillFarBackground) continue;
                    this.fillEnemies(game, removeController, enemyConfig, chunkCenter);
                }
                return Optional.of(beltConfig.envConfig);
            }
            float percentage = distanceToSystem / system.getRadius() * 2.0f;
            if (percentage > 1.0f) {
                percentage = 2.0f - percentage;
            }
            densityMultiplier[0] = percentage;
            if (!fillFarBackground) {
                boolean isPlanetNear;
                Planet planet = planetManager.getNearestPlanet(chunkCenter);
                float distanceToPlanet = planet.getPosition().dst(chunkCenter);
                boolean bl = isPlanetNear = distanceToPlanet < planet.getFullHeight() + 20.0f;
                if (!isPlanetNear) {
                    this.fillForSys(game, chunkCenter, removeController, system);
                }
            }
            return Optional.of(system.getConfig().envConfig);
        }
        Maze maze = planetManager.getNearestMaze(chunkCenter);
        float distanceToMaze = maze.getPos().dst(chunkCenter);
        if (distanceToMaze < (zoneRadius = maze.getRadius() + 20.0f)) {
            densityMultiplier[0] = 1.0f - distanceToMaze / zoneRadius;
            return Optional.of(maze.getConfig().envConfig);
        }
        return Optional.empty();
    }

    private void fillForSys(SolGame game, Vector2 chunkCenter, RemoveController removeController, SolSystem system) {
        SysConfig config = system.getConfig();
        Vector2 mainStationPosition = game.getGalaxyFiller().getMainStationPosition();
        Vector2 startPosition = mainStationPosition == null ? new Vector2() : mainStationPosition;
        float distanceToStartPosition = chunkCenter.dst(startPosition);
        if (20.0f < distanceToStartPosition) {
            this.fillAsteroids(game, removeController, false, chunkCenter);
            ArrayList<ShipConfig> enemies = system.getPosition().dst(chunkCenter) < system.getInnerRadius() ? config.innerTempEnemies : config.tempEnemies;
            for (ShipConfig enemyConfig : enemies) {
                this.fillEnemies(game, removeController, enemyConfig, chunkCenter);
            }
        }
    }

    private void fillEnemies(SolGame game, RemoveController removeController, ShipConfig enemyConfig, Vector2 chunkCenter) {
        int enemyCount = this.getEntityCount(enemyConfig.density);
        if (enemyCount == 0) {
            return;
        }
        for (int i = 0; i < enemyCount; ++i) {
            Optional<Vector2> enemyPosition = this.getFreeRndPos(game, chunkCenter);
            enemyPosition.ifPresent(enemyPos -> {
                FarShip ship = this.buildSpaceEnemy(game, (Vector2)enemyPos, removeController, enemyConfig);
                game.getObjectManager().addFarObjNow(ship);
            });
        }
    }

    private FarShip buildSpaceEnemy(SolGame game, Vector2 position, RemoveController remover, ShipConfig enemyConf) {
        Vector2 velocity = new Vector2();
        SolMath.fromAl(velocity, SolRandom.randomFloat(180.0f), SolRandom.randomFloat(0.0f, 0.3f));
        float rotationSpeed = SolRandom.randomFloat(15.0f);
        StillGuard dp = new StillGuard(position, game, enemyConf);
        AiPilot provider = new AiPilot(dp, false, Faction.EHAR, true, null, 5.4f);
        HullConfig config = enemyConf.hull;
        int money = enemyConf.money;
        float angle = SolRandom.randomFloat(180.0f);
        return game.getShipBuilder().buildNewFar(game, position, velocity, angle, rotationSpeed, provider, enemyConf.items, config, remover, false, money, null, true);
    }

    private void fillAsteroids(SolGame game, RemoveController remover, boolean forBelt, Vector2 chunkCenter) {
        float density = forBelt ? 0.04f : 0.008f;
        int count = this.getEntityCount(density);
        if (count == 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            Optional<Vector2> asteroidPosition = this.getFreeRndPos(game, chunkCenter);
            asteroidPosition.ifPresent(asteroidPos -> {
                float minSz = forBelt ? 0.4f : 0.5f;
                float maxSz = forBelt ? 2.4f : 1.2f;
                float sz = SolRandom.randomFloat(minSz, maxSz);
                Vector2 velocity = new Vector2();
                SolMath.fromAl(velocity, SolRandom.randomFloat(180.0f), 0.2f);
                FarAsteroid a = game.getAsteroidBuilder().buildNewFar((Vector2)asteroidPos, velocity, sz, remover);
                game.getObjectManager().addFarObjNow(a);
            });
        }
    }

    private void fillFarJunk(SolGame game, Vector2 chunkCenter, RemoveController remover, DrawableLevel drawableLevel, SpaceEnvConfig conf, float densityMul) {
        int count = this.getEntityCount(conf.farJunkDensity * densityMul);
        if (count == 0) {
            return;
        }
        ArrayList<Drawable> drawables = new ArrayList<Drawable>();
        for (int i = 0; i < count; ++i) {
            TextureAtlas.AtlasRegion tex = new TextureAtlas.AtlasRegion(SolRandom.randomElement(conf.farJunkTextures));
            if (SolRandom.test(0.5f)) {
                tex.flip(!tex.isFlipX(), !tex.isFlipY());
            }
            float sz = SolRandom.randomFloat(0.3f, 1.0f) * 2.0f;
            float rotationSpeed = SolRandom.randomFloat(10.0f);
            Vector2 junkPos = this.getRndPos(chunkCenter);
            junkPos.sub(chunkCenter);
            RectSprite s = SpriteManager.createSprite(tex.name, sz, 0.0f, 0.0f, junkPos, drawableLevel, SolRandom.randomFloat(180.0f), rotationSpeed, SolColor.DDG, false);
            drawables.add(s);
        }
        FarDrawable so = new FarDrawable(drawables, new Vector2(chunkCenter), new Vector2(), remover, true);
        game.getObjectManager().addFarObjNow(so);
    }

    private void fillJunk(SolGame game, RemoveController remover, SpaceEnvConfig conf, Vector2 chunkCenter) {
        int count = this.getEntityCount(conf.junkDensity);
        if (count == 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            Vector2 junkPos = this.getRndPos(chunkCenter);
            TextureAtlas.AtlasRegion tex = new TextureAtlas.AtlasRegion(SolRandom.randomElement(conf.junkTextures));
            if (SolRandom.test(0.5f)) {
                tex.flip(!tex.isFlipX(), !tex.isFlipY());
            }
            float sz = SolRandom.randomFloat(0.3f, 1.0f) * 0.3f;
            float rotationSpeed = SolRandom.randomFloat(45.0f);
            RectSprite s = SpriteManager.createSprite(tex.name, sz, 0.0f, 0.0f, new Vector2(), DrawableLevel.DECO, SolRandom.randomFloat(180.0f), rotationSpeed, SolColor.LG, false);
            ArrayList<Drawable> drawables = new ArrayList<Drawable>();
            drawables.add(s);
            Vector2 velocity = new Vector2();
            SolMath.fromAl(velocity, SolRandom.randomFloat(180.0f), SolRandom.randomFloat(0.3f));
            FarDrawable so = new FarDrawable(drawables, junkPos, velocity, remover, true);
            game.getObjectManager().addFarObjNow(so);
        }
    }

    private void fillDust(SolGame game, Vector2 chunkCenter, RemoveController remover) {
        ArrayList<Drawable> drawables = new ArrayList<Drawable>();
        int count = this.getEntityCount(0.2f);
        if (count == 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            Vector2 dustPos = this.getRndPos(chunkCenter);
            dustPos.sub(chunkCenter);
            RectSprite s = SpriteManager.createSprite(this.dustTexture.name, 0.02f, 0.0f, 0.0f, dustPos, DrawableLevel.DECO, 0.0f, 0.0f, SolColor.WHITE, false);
            drawables.add(s);
        }
        FarDrawable so = new FarDrawable(drawables, chunkCenter, new Vector2(), remover, true);
        game.getObjectManager().addFarObjNow(so);
    }

    private Optional<Vector2> getFreeRndPos(SolGame game, Vector2 chunkCenter) {
        for (int i = 0; i < 100; ++i) {
            Vector2 position = this.getRndPos(chunkCenter);
            if (!game.isPlaceEmpty(position, true)) continue;
            return Optional.of(position);
        }
        return Optional.empty();
    }

    private Vector2 getRndPos(Vector2 chunkCenter) {
        Vector2 position = new Vector2(chunkCenter);
        position.x += SolRandom.randomFloat(10.0f);
        position.y += SolRandom.randomFloat(10.0f);
        return position;
    }

    private int getEntityCount(float density) {
        float amt = 400.0f * density;
        if (amt >= 1.0f) {
            return (int)amt;
        }
        return SolRandom.test(amt) ? 1 : 0;
    }
}

