/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.chunk;

import com.badlogic.gdx.math.Vector2;
import java.util.HashSet;
import java.util.Set;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.RemoveController;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.UpdateAwareSystem;
import org.destinationsol.game.chunk.ChunkFiller;

public class ChunkManager
implements UpdateAwareSystem {
    private static final int MAX_FILL_DIST = 1;
    private static final int MIN_REMOVE_DIST = 3;
    private static final int MAX_BG_FILL_DIST = 2;
    private static final int MIN_BG_REMOVE_DIST = 3;
    private final Set<Vector2> filledChunks = new HashSet<Vector2>();
    private final Set<Vector2> backgroundFilledChunks = new HashSet<Vector2>();
    private final RemoveController removeController = new MyRemover(3);
    private final RemoveController backgroundRemoveController = new MyRemover(3);
    private final ChunkFiller filler = new ChunkFiller();
    private int x;
    private int y;

    @Override
    public void update(SolGame game, float timeStep) {
        Vector2 camPos = game.getCam().getPosition();
        boolean refill = this.updateCurrChunk(camPos);
        if (refill) {
            this.clearFarChunks(this.filledChunks, 3);
            this.addNewChunks(this.filledChunks, 1, game);
            this.clearFarChunks(this.backgroundFilledChunks, 3);
            this.addNewChunks(this.backgroundFilledChunks, 2, game);
        }
    }

    private boolean updateCurrChunk(Vector2 position) {
        int oldX = this.x;
        int oldY = this.y;
        this.x = this.posToChunkIdx(position.x);
        this.y = this.posToChunkIdx(position.y);
        return oldX != this.x || oldY != this.y;
    }

    private int posToChunkIdx(float v) {
        int i = (int)(v / 20.0f);
        if (v < 0.0f) {
            --i;
        }
        return i;
    }

    private void clearFarChunks(Set<Vector2> chunks, int dist) {
        chunks.removeIf(chunk -> this.isChunkFar((int)chunk.x, (int)chunk.y, dist));
    }

    private boolean isChunkFar(int x, int y, int dist) {
        return x <= this.x - dist || this.x + dist <= x || y <= this.y - dist || this.y + dist <= y;
    }

    private void addNewChunks(Set<Vector2> chunks, int dist, SolGame game) {
        this.maybeAddChunk(chunks, 0, 0, game);
        for (int i = -dist; i < dist + 1; ++i) {
            for (int j = -dist; j < dist + 1; ++j) {
                if (i == 0 && j == 0) continue;
                this.maybeAddChunk(chunks, i, j, game);
            }
        }
    }

    private void maybeAddChunk(Set<Vector2> chunks, int oX, int oY, SolGame game) {
        Vector2 v = SolMath.getVec(this.x + oX, this.y + oY);
        if (!chunks.contains(v)) {
            Vector2 chunk = new Vector2(v);
            chunks.add(chunk);
            boolean background = chunks == this.backgroundFilledChunks;
            this.filler.fill(game, chunk, background ? this.backgroundRemoveController : this.removeController, background);
        }
        SolMath.free(v);
    }

    public boolean isInactive(Vector2 position, int dist) {
        int x = this.posToChunkIdx(position.x);
        int y = this.posToChunkIdx(position.y);
        return this.isChunkFar(x, y, dist);
    }

    private class MyRemover
    implements RemoveController {
        private final int myMinRemoveDist;

        public MyRemover(int minRemoveDist) {
            this.myMinRemoveDist = minRemoveDist;
        }

        @Override
        public boolean shouldRemove(Vector2 position) {
            return ChunkManager.this.isInactive(position, this.myMinRemoveDist);
        }
    }
}

