/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.console;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Primitives;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.destinationsol.SolApplication;
import org.destinationsol.game.console.CommandParameterSuggester;
import org.destinationsol.game.console.Parameter;
import org.destinationsol.game.console.adapter.ParameterAdapterManager;
import org.destinationsol.game.console.exceptions.CommandParameterParseException;
import org.destinationsol.game.console.exceptions.SuggesterInstantiationException;
import org.destinationsol.game.context.Context;
import org.destinationsol.util.InjectionHelper;

public final class CommandParameter<T>
implements Parameter {
    private final String name;
    private final Class<T> type;
    private final CommandParameterSuggester<T> suggester;
    private final boolean required;
    private final ParameterAdapterManager parameterAdapterManager;
    private Context context;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CommandParameter(String name, Class<T> typeParam, boolean required, CommandParameterSuggester<T> suggester, ParameterAdapterManager parameterAdapterManager, Context context) {
        Class resultType;
        this.context = context;
        Preconditions.checkNotNull((Object)name, (Object)"The parameter name must not be null!");
        if (name.length() <= 0) {
            throw new IllegalArgumentException("The parameter name must not be empty!");
        }
        Preconditions.checkNotNull((Object)typeParam, (Object)"The parameter type must not be null!");
        if (typeParam.isPrimitive()) {
            if (!required) throw new IllegalArgumentException("An optional parameter must not be primitive! Use " + Primitives.wrap((Class)typeParam).getSimpleName() + " instead of " + typeParam.getSimpleName() + ".");
            resultType = Primitives.wrap((Class)typeParam);
        } else {
            resultType = typeParam;
        }
        Preconditions.checkNotNull(suggester, (Object)"The suggester must not be null!");
        this.name = name;
        this.type = resultType;
        this.suggester = suggester;
        this.required = required;
        this.parameterAdapterManager = parameterAdapterManager;
    }

    public static <T> CommandParameter single(String name, Class<T> type, boolean required, CommandParameterSuggester<T> suggester, Context context) {
        if (type.isArray()) {
            throw new IllegalArgumentException("The type of a simple CommandParameterDefinition must not be an array!");
        }
        ParameterAdapterManager parameterAdapterManager = context.get(SolApplication.class).getParameterAdapterManager();
        return new CommandParameter<T>(name, type, required, suggester, parameterAdapterManager, context);
    }

    public static <T> CommandParameter single(String name, Class<T> type, boolean required, Class<? extends CommandParameterSuggester<T>> suggesterClass, Context context) throws SuggesterInstantiationException {
        CommandParameterSuggester<T> suggester = CommandParameter.optionallyCreateSuggestor(suggesterClass, context);
        return CommandParameter.single(name, type, required, suggester, context);
    }

    private static <T> CommandParameterSuggester<T> optionallyCreateSuggestor(Class<? extends CommandParameterSuggester<T>> suggestorClass, Context context) {
        if (suggestorClass == null) {
            return null;
        }
        return InjectionHelper.createWithConstructorInjection(suggestorClass, context);
    }

    public static CommandParameter single(String name, Class<?> type, boolean required, Context context) {
        return CommandParameter.single(name, type, required, (CommandParameterSuggester)null, context);
    }

    public static <T> CommandParameter array(String name, Class<T> childType, Character arrayDelimiter, boolean required, CommandParameterSuggester<T> suggester, Context context) {
        if (childType.isArray()) {
            throw new IllegalArgumentException("The child type of an array CommandParameterDefinition must not be an array!");
        }
        Class<T[]> type = CommandParameter.getArrayClass(childType);
        ParameterAdapterManager parameterAdapterManager = context.get(SolApplication.class).getParameterAdapterManager();
        return new CommandParameter<T[]>(name, type, required, suggester, parameterAdapterManager, context);
    }

    public static <T> CommandParameter array(String name, Class<T> childType, Character arrayDelimiter, boolean required, Class<? extends CommandParameterSuggester<T>> suggesterClass, Context context) throws SuggesterInstantiationException {
        CommandParameterSuggester<T> suggester = CommandParameter.optionallyCreateSuggestor(suggesterClass, context);
        return CommandParameter.array(name, childType, arrayDelimiter, required, suggester, context);
    }

    public static CommandParameter array(String name, Class<?> childType, Character arrayDelimiter, boolean required, Context context) {
        return CommandParameter.array(name, childType, arrayDelimiter, required, (CommandParameterSuggester)null, context);
    }

    public static <T> CommandParameter array(String name, Class<T> childType, boolean required, CommandParameterSuggester<T> suggester, Context context) {
        return CommandParameter.array(name, childType, null, required, suggester, context);
    }

    public static <T> CommandParameter array(String name, Class<T> childType, boolean required, Class<? extends CommandParameterSuggester<T>> suggesterClass, Context context) throws SuggesterInstantiationException {
        CommandParameterSuggester<T> suggester = CommandParameter.optionallyCreateSuggestor(suggesterClass, context);
        return CommandParameter.array(name, childType, required, suggester, context);
    }

    public static CommandParameter array(String name, Class<?> childType, boolean required, Context context) {
        return CommandParameter.array(name, childType, required, (CommandParameterSuggester)null, context);
    }

    public static <T> CommandParameter varargs(String name, Class<T> childType, boolean required, CommandParameterSuggester<T> suggester, Context context) {
        return CommandParameter.array(name, childType, required, suggester, context);
    }

    public static <T> CommandParameter varargs(String name, Class<T> childType, boolean required, Class<? extends CommandParameterSuggester<T>> suggesterClass, Context context) throws SuggesterInstantiationException {
        return CommandParameter.varargs(name, childType, required, CommandParameter.optionallyCreateSuggestor(suggesterClass, context), context);
    }

    public static CommandParameter varargs(String name, Class<?> childType, boolean required, Context context) {
        return CommandParameter.varargs(name, childType, required, (CommandParameterSuggester)null, context);
    }

    private static <T> Class<? extends T[]> getArrayClass(Class<T> clazz) {
        return Array.newInstance(clazz, 0).getClass();
    }

    public Object getValue(String param) throws CommandParameterParseException {
        if (!this.isArray()) {
            return this.parse(param);
        }
        return this.getArrayValue(Arrays.asList(param));
    }

    public Object getArrayValue(List<String> params) throws CommandParameterParseException {
        Object arrayInstance = Array.newInstance(this.getType(), params.size());
        for (int i = 0; i < params.size(); ++i) {
            Array.set(arrayInstance, i, this.parse(params.get(i)));
        }
        return arrayInstance;
    }

    private Object parse(String string) throws CommandParameterParseException {
        Class<?> childType = this.getTypeNotPrimitive();
        if (this.parameterAdapterManager.isAdapterRegistered(childType)) {
            try {
                return this.parameterAdapterManager.parse(childType, string);
            }
            catch (Error | Exception e) {
                throw new CommandParameterParseException("An error occurred while parsing " + this.getType().getCanonicalName(), e, string);
            }
        }
        throw new CommandParameterParseException("Cannot parse a " + childType.getCanonicalName(), string);
    }

    public String convertToString(Object object) {
        return this.parameterAdapterManager.convertToString(object, this.getType());
    }

    public Set<T> suggest(Object ... parameters) {
        return this.suggester.suggest(this.context.get(SolApplication.class).getGame(), parameters);
    }

    public String getUsage() {
        String simpleTypeName = this.getType().getSimpleName();
        StringBuilder usage = new StringBuilder(simpleTypeName);
        if (this.hasName()) {
            usage.append(' ').append(this.getName());
        }
        if (this.isArray()) {
            usage.insert(0, '(');
            usage.append("...)");
        } else if (this.isRequired()) {
            usage.insert(0, '<');
            usage.append('>');
        } else {
            usage.insert(0, '(');
            usage.append(')');
        }
        return usage.toString();
    }

    public boolean isArray() {
        return this.type.isArray();
    }

    public boolean hasName() {
        return this.name.length() > 0;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        if (this.type.isArray()) {
            return this.type.getComponentType();
        }
        return this.type;
    }

    public Class<?> getTypeNotPrimitive() {
        Class<?> componentType = this.getType();
        if (componentType.isPrimitive()) {
            return Primitives.wrap(componentType);
        }
        return componentType;
    }

    public Class<T> getTypeRaw() {
        return this.type;
    }

    public CommandParameterSuggester<T> getSuggester() {
        return this.suggester;
    }

    public boolean isRequired() {
        return this.required && !this.isArray();
    }

    @Override
    public Optional<? extends Class<?>> getProvidedType() {
        return Optional.of(this.getTypeRaw());
    }
}

