/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.console;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.destinationsol.game.console.CommandParameter;
import org.destinationsol.game.console.exceptions.CommandExecutionException;
import org.destinationsol.game.console.exceptions.CommandSuggestionException;

public interface ConsoleCommand
extends Comparable<ConsoleCommand> {
    public static final Comparator<ConsoleCommand> COMPARATOR = new Comparator<ConsoleCommand>(){

        @Override
        public int compare(ConsoleCommand o1, ConsoleCommand o2) {
            int nameComparison = o1.getName().compareTo(o2.getName());
            if (nameComparison != 0) {
                return nameComparison;
            }
            if (!o1.endsWithVarargs() && o2.endsWithVarargs()) {
                return -1;
            }
            if (o1.endsWithVarargs() && !o2.endsWithVarargs()) {
                return 1;
            }
            return o2.getRequiredParameterCount() - o1.getRequiredParameterCount();
        }
    };

    public String getName();

    public ImmutableList<CommandParameter> getCommandParameters();

    public String getDescription();

    public String getHelpText();

    public int getRequiredParameterCount();

    public boolean endsWithVarargs();

    public String getUsage();

    public Object getSource();

    public String execute(List<String> var1) throws CommandExecutionException;

    public Set<String> suggest(String var1, List<String> var2) throws CommandSuggestionException;

    @Override
    public int compareTo(ConsoleCommand var1);
}

