/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.console;

import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.console.Console;
import org.destinationsol.game.console.ConsoleCommand;
import org.destinationsol.game.console.ConsoleSubscriber;
import org.destinationsol.game.console.CoreMessageType;
import org.destinationsol.game.console.Message;
import org.destinationsol.game.console.MessageType;
import org.destinationsol.game.console.MethodCommand;
import org.destinationsol.game.console.annotations.RegisterCommands;
import org.destinationsol.game.console.exceptions.CommandExecutionException;
import org.destinationsol.game.context.Context;
import org.destinationsol.modules.ModuleManager;
import org.destinationsol.util.CircularBuffer;
import org.destinationsol.util.InjectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleImpl
implements Console {
    public static final int MAX_MESSAGE_HISTORY = 20;
    public static final int MAX_WIDTH_OF_LINE = 1040;
    private static final String PARAM_SPLIT_REGEX = " (?=([^\"]*\"[^\"]*\")*[^\"]*$)";
    private static final int MAX_COMMAND_HISTORY = 30;
    private static final Logger logger = LoggerFactory.getLogger(ConsoleImpl.class);
    public static Console instance;
    private final CircularBuffer<Message> messageHistory = CircularBuffer.create(20);
    private final CircularBuffer<String> localCommandHistory = CircularBuffer.create(30);
    private final Map<String, ConsoleCommand> commandRegistry = Maps.newHashMap();
    private final Set<ConsoleSubscriber> messageSubscribers = Sets.newHashSet();
    private final Context context;
    private BitmapFont font;

    public ConsoleImpl(BitmapFont font, Context context) {
        this.font = font;
        this.context = context;
        instance = this;
    }

    private static String cleanCommand(String rawCommand) {
        return rawCommand.trim().replaceAll("\\s\\s+", " ");
    }

    private static List<String> splitParameters(String paramStr) {
        String[] rawParams = paramStr.split(PARAM_SPLIT_REGEX);
        ArrayList params = Lists.newArrayList();
        for (String s : rawParams) {
            String param = s;
            if (param.trim().isEmpty()) continue;
            if (param.length() > 1 && param.startsWith("\"") && param.endsWith("\"")) {
                param = param.substring(1, param.length() - 1);
            }
            params.add(param);
        }
        return params;
    }

    @Override
    public void init(SolGame game) {
        for (Class commands : this.context.get(ModuleManager.class).getEnvironment().getTypesAnnotatedWith(RegisterCommands.class)) {
            try {
                Object commandsObject = commands.newInstance();
                InjectionHelper.inject(commandsObject, this.context);
                MethodCommand.registerAvailable(commandsObject, this, game, this.context);
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void registerCommand(ConsoleCommand command) {
        String commandName = command.getName().toLowerCase();
        if (this.commandRegistry.containsKey(commandName)) {
            logger.warn("Command with name '{}' already registered by class '{}', skipping '{}'", new Object[]{commandName, this.commandRegistry.get(commandName).getSource().getClass().getCanonicalName(), command.getSource().getClass().getCanonicalName()});
        } else {
            this.commandRegistry.put(commandName, command);
            logger.debug("Command '{}' successfully registered for class '{}'.", (Object)commandName, (Object)command.getSource().getClass().getCanonicalName());
        }
    }

    @Override
    public void dispose() {
        this.commandRegistry.clear();
        this.messageHistory.clear();
    }

    @Override
    public void addMessage(String message) {
        this.addMessage(new Message(message));
    }

    @Override
    public void addMessage(String message, MessageType type) {
        this.addMessage(new Message(message, type));
    }

    private void addErrorMessage(String message) {
        this.addMessage(new Message(message, CoreMessageType.ERROR));
    }

    @Override
    public void addMessage(Message message) {
        String uncoloredText = message.getMessage();
        logger.info("[{}] {}", (Object)message.getType(), (Object)uncoloredText);
        ArrayList<Message> newlinedMessages = new ArrayList<Message>();
        if (message.getMessage().indexOf("\n") > 0) {
            for (String line : message.getMessage().split("\n")) {
                newlinedMessages.add(new Message(line, message.getType()));
            }
        } else {
            newlinedMessages.add(message);
        }
        BitmapFont.BitmapFontData fontData = this.font.getData();
        for (Message messageToCheck : newlinedMessages) {
            int messageWidth = 0;
            StringBuilder fittingMessageText = new StringBuilder();
            for (char c : messageToCheck.getMessage().toCharArray()) {
                int charWidth = fontData.getGlyph((char)c).width;
                charWidth = charWidth < 10 ? 10 : charWidth;
                fittingMessageText.append(c);
                if ((messageWidth += charWidth) <= 1040) continue;
                Message newMessage = new Message(fittingMessageText.toString(), message.getType());
                this.messageHistory.add(newMessage);
                fittingMessageText = new StringBuilder();
                messageWidth = 0;
            }
            Message newMessage = new Message(fittingMessageText.toString(), message.getType());
            this.messageHistory.add(newMessage);
        }
        for (ConsoleSubscriber subscriber : this.messageSubscribers) {
            subscriber.onNewConsoleMessage(message);
        }
    }

    @Override
    public void removeMessage(Message message) {
        this.messageHistory.remove(message);
    }

    @Override
    public void clear() {
        this.messageHistory.clear();
    }

    @Override
    public void replaceMessage(Message oldMsg, Message newMsg) {
        int idx = this.messageHistory.indexOf(oldMsg);
        if (idx >= 0) {
            this.messageHistory.set(idx, newMsg);
        }
    }

    @Override
    public Iterable<Message> getMessages() {
        return this.messageHistory;
    }

    @Override
    public Iterable<Message> getMessages(MessageType ... types) {
        List<MessageType> allowedTypes = Arrays.asList(types);
        return Collections2.filter(this.messageHistory, input -> allowedTypes.contains(input.getType()));
    }

    @Override
    public List<String> getPreviousCommands() {
        return ImmutableList.copyOf(this.localCommandHistory);
    }

    @Override
    public void subscribe(ConsoleSubscriber subscriber) {
        this.messageSubscribers.add(subscriber);
    }

    @Override
    public void unsubscribe(ConsoleSubscriber subscriber) {
        this.messageSubscribers.remove(subscriber);
    }

    @Override
    public boolean execute(String rawCommand) {
        String commandName = this.processCommandName(rawCommand);
        commandName = commandName.toLowerCase();
        List<String> processedParameters = this.processParameters(rawCommand);
        if (!(rawCommand.isEmpty() || !this.localCommandHistory.isEmpty() && this.localCommandHistory.getLast().equals(rawCommand))) {
            this.localCommandHistory.add(rawCommand);
        }
        return this.execute(commandName, processedParameters);
    }

    @Override
    public boolean execute(String commandName, List<String> params) {
        if (commandName.isEmpty()) {
            return false;
        }
        ConsoleCommand cmd = this.getCommand(commandName);
        if (cmd == null) {
            this.addErrorMessage("Unknown command '" + commandName + "'");
            return false;
        }
        if (params.size() < cmd.getRequiredParameterCount()) {
            this.addMessage(new Message("Please, provide required arguments marked by <>.", CoreMessageType.WARN));
            this.addMessage(cmd.getUsage(), CoreMessageType.WARN);
            return false;
        }
        try {
            String result = cmd.execute(params);
            if (result != null) {
                this.addMessage(result);
            }
            return true;
        }
        catch (CommandExecutionException e) {
            String causeMessage;
            Throwable cause = e.getCause();
            if (cause != null) {
                causeMessage = cause.getLocalizedMessage();
                if (Strings.isNullOrEmpty((String)causeMessage)) {
                    causeMessage = cause.toString();
                }
            } else {
                causeMessage = e.getLocalizedMessage();
            }
            logger.error("An error occurred while executing a command '" + cmd.getName() + "' : " + e.getMessage(), (Object)CoreMessageType.ERROR);
            if (!Strings.isNullOrEmpty((String)causeMessage)) {
                this.addMessage(new Message("Error: " + causeMessage));
            }
            return false;
        }
    }

    @Override
    public String processCommandName(String rawCommand) {
        String cleanedCommand = ConsoleImpl.cleanCommand(rawCommand);
        int commandEndIndex = cleanedCommand.indexOf(" ");
        if (commandEndIndex >= 0) {
            return cleanedCommand.substring(0, commandEndIndex);
        }
        return cleanedCommand;
    }

    @Override
    public List<String> processParameters(String rawCommand) {
        String cleanedCommand = ConsoleImpl.cleanCommand(rawCommand);
        int commandEndIndex = cleanedCommand.indexOf(" ");
        if (commandEndIndex < 0) {
            commandEndIndex = cleanedCommand.length();
        }
        String parameterPart = cleanedCommand.substring(commandEndIndex).trim();
        List<String> params = ConsoleImpl.splitParameters(parameterPart);
        return params;
    }

    @Override
    public ConsoleCommand getCommand(String name) {
        return this.commandRegistry.get(name.toLowerCase());
    }

    @Override
    public Collection<ConsoleCommand> getCommands() {
        return this.commandRegistry.values();
    }
}

