/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.console;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.destinationsol.game.console.Console;
import org.destinationsol.game.console.ConsoleCommand;
import org.destinationsol.game.console.CoreMessageType;
import org.destinationsol.game.console.Message;
import org.destinationsol.game.console.TabCompletionEngine;
import org.destinationsol.game.console.exceptions.CommandSuggestionException;
import org.destinationsol.util.CamelCaseMatcher;

public class CyclingTabCompletionEngine
implements TabCompletionEngine {
    private final Console console;
    private int selectionIndex;
    private List<String> previousMatches;
    private Message previousMessage;
    private Collection<String> commandNames;
    private String query;

    public CyclingTabCompletionEngine(Console console) {
        this.console = console;
    }

    private boolean updateCommandNamesIfNecessary() {
        Collection<ConsoleCommand> commands = this.console.getCommands();
        if (this.commandNames != null && this.commandNames.size() == commands.size()) {
            return false;
        }
        this.commandNames = Collections2.transform(commands, input -> input.getName());
        return true;
    }

    private Set<String> findMatches(String commandName, List<String> commandParameters, ConsoleCommand command, int suggestedIndex) {
        if (suggestedIndex <= 0) {
            this.updateCommandNamesIfNecessary();
            return CamelCaseMatcher.getMatches(commandName, this.commandNames, true);
        }
        if (command == null) {
            return null;
        }
        ArrayList finishedParameters = Lists.newArrayList();
        for (int i = 0; i < suggestedIndex - 1; ++i) {
            finishedParameters.add(commandParameters.get(i));
        }
        String currentValue = commandParameters.size() >= suggestedIndex ? commandParameters.get(suggestedIndex - 1) : null;
        try {
            return command.suggest(currentValue, finishedParameters);
        }
        catch (CommandSuggestionException e) {
            Throwable cause;
            String causeMessage = e.getLocalizedMessage();
            if (causeMessage == null && ((causeMessage = (cause = e.getCause()).getLocalizedMessage()) == null || causeMessage.isEmpty()) && ((causeMessage = cause.toString()) == null || causeMessage.isEmpty())) {
                return null;
            }
            this.console.addMessage("Error when suggesting command: " + causeMessage, CoreMessageType.ERROR);
            return null;
        }
    }

    @Override
    public String complete(String rawCommand) {
        int suggestedIndex;
        ConsoleCommand command;
        List<String> commandParameters;
        String commandNameRaw;
        String commandName;
        Set<String> matches;
        if (rawCommand.length() <= 0) {
            this.reset();
            this.previousMessage = new Message("Type 'help' to list all commands.");
            this.console.addMessage(this.previousMessage);
            return null;
        }
        if (this.query == null) {
            this.query = rawCommand;
        }
        if ((matches = this.findMatches(commandName = (commandNameRaw = this.console.processCommandName(this.query)), commandParameters = this.console.processParameters(this.query), command = this.console.getCommand(commandName), suggestedIndex = commandParameters.size() + (this.query.charAt(this.query.length() - 1) == ' ' ? 1 : 0))) == null || matches.size() <= 0) {
            return this.query;
        }
        if (this.previousMatches == null || !matches.equals(Sets.newHashSet(this.previousMatches))) {
            this.reset(false);
            if (matches.size() == 1) {
                return this.generateResult(matches.iterator().next(), commandName, commandParameters, suggestedIndex);
            }
            this.previousMatches = Lists.newArrayList(matches);
            Collections.sort(this.previousMatches);
        }
        StringBuilder matchMessageString = new StringBuilder();
        for (int i = 0; i < this.previousMatches.size(); ++i) {
            if (i > 0) {
                matchMessageString.append(' ');
            }
            String match = this.previousMatches.get(i);
            matchMessageString.append(match);
        }
        Message matchMessage = new Message(matchMessageString.toString());
        String suggestion = this.previousMatches.get(this.selectionIndex);
        if (this.previousMessage != null) {
            this.console.replaceMessage(this.previousMessage, matchMessage);
        } else {
            this.console.addMessage(matchMessage);
        }
        this.previousMessage = matchMessage;
        this.selectionIndex = (this.selectionIndex + 1) % this.previousMatches.size();
        return this.generateResult(suggestion, commandName, commandParameters, suggestedIndex);
    }

    private String generateResult(String suggestion, String commandName, List<String> commandParameters, int suggestedIndex) {
        if (suggestedIndex <= 0) {
            return suggestion + " ";
        }
        StringBuilder result = new StringBuilder();
        result.append(commandName);
        for (int i = 0; i < suggestedIndex - 1; ++i) {
            result.append(" ");
            result.append(commandParameters.get(i));
        }
        result.append(" ");
        result.append(suggestion);
        result.append(" ");
        return result.toString();
    }

    private void reset(boolean removeQuery) {
        if (this.previousMessage != null) {
            this.console.removeMessage(this.previousMessage);
        }
        if (removeQuery) {
            this.query = null;
        }
        this.previousMessage = null;
        this.previousMatches = null;
        this.selectionIndex = 0;
    }

    @Override
    public void reset() {
        this.reset(true);
    }
}

