/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.console;

import org.destinationsol.game.console.CoreMessageType;
import org.destinationsol.game.console.MessageType;

public class Message {
    private final MessageType type;
    private final String message;

    public Message(String message) {
        this.message = message;
        this.type = CoreMessageType.INFO;
    }

    public Message(String message, MessageType type) {
        this.message = message;
        this.type = type;
    }

    public String getMessage() {
        return this.message;
    }

    public MessageType getType() {
        return this.type;
    }

    public String toString() {
        return String.format("[%s] '%s'", this.type, this.message);
    }

    public static Message SUCCESS(String status) {
        return new Message(status, CoreMessageType.INFO);
    }

    public static Message FAILURE(String status) {
        return new Message(status, CoreMessageType.ERROR);
    }

    public static Message WARN(String status) {
        return new Message(status, CoreMessageType.WARN);
    }
}

