/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.console;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.console.AbstractCommand;
import org.destinationsol.game.console.CommandParameter;
import org.destinationsol.game.console.CommandParameterSuggester;
import org.destinationsol.game.console.Console;
import org.destinationsol.game.console.MarkerParameters;
import org.destinationsol.game.console.Parameter;
import org.destinationsol.game.console.annotations.Command;
import org.destinationsol.game.console.annotations.CommandParam;
import org.destinationsol.game.console.annotations.Game;
import org.destinationsol.game.context.Context;
import org.destinationsol.util.InjectionHelper;
import org.destinationsol.util.SpecificAccessibleObject;
import org.reflections.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MethodCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger(MethodCommand.class);

    private MethodCommand(String name, String description, String helpText, SpecificAccessibleObject<Method> executionMethod, SolGame game, Context context) {
        super(name, description, helpText, executionMethod, game, context);
    }

    public static MethodCommand referringTo(SpecificAccessibleObject<Method> specificMethod, SolGame game, Context context) {
        Method method = specificMethod.getAccessibleObject();
        Command commandAnnotation = method.getAnnotation(Command.class);
        Preconditions.checkNotNull((Object)commandAnnotation);
        String nameString = commandAnnotation.value();
        if (nameString.length() <= 0) {
            nameString = method.getName();
        }
        String name = nameString;
        return new MethodCommand(name, commandAnnotation.shortDescription(), commandAnnotation.helpText(), specificMethod, game, context);
    }

    public static void registerAvailable(Object provider, Console console, SolGame game, Context context) {
        Predicate predicate = Predicates.and((Predicate)ReflectionUtils.withModifier((int)1), (Predicate)ReflectionUtils.withAnnotation(Command.class));
        Set commandMethods = ReflectionUtils.getAllMethods(provider.getClass(), (Predicate[])new Predicate[]{predicate});
        for (Method method : commandMethods) {
            if (!MethodCommand.hasSenderAnnotation(method)) {
                logger.error("Command {} provided by {} contains a EntityRef without @Sender annotation, may cause a NullPointerException", (Object)method.getName(), (Object)provider.getClass().getSimpleName());
            }
            logger.debug("Registering command method {} in class {}", (Object)method.getName(), (Object)method.getDeclaringClass().getCanonicalName());
            try {
                SpecificAccessibleObject<Method> specificMethod = new SpecificAccessibleObject<Method>(method, provider);
                MethodCommand command = MethodCommand.referringTo(specificMethod, game, context);
                console.registerCommand(command);
                logger.debug("Registered command method {} in class {}", (Object)method.getName(), (Object)method.getDeclaringClass().getCanonicalName());
            }
            catch (RuntimeException t) {
                logger.error("Failed to load command method {} in class {}", new Object[]{method.getName(), method.getDeclaringClass().getCanonicalName(), t});
            }
        }
    }

    private static boolean hasSenderAnnotation(Method method) {
        return true;
    }

    private static Parameter getParameterTypeFor(Class<?> type, Annotation[] annotations, Context context) {
        for (Annotation annotation : annotations) {
            if (annotation instanceof CommandParam) {
                CommandParam parameterAnnotation = (CommandParam)annotation;
                String name = parameterAnnotation.value();
                Class<? extends CommandParameterSuggester> suggesterClass = parameterAnnotation.suggester();
                boolean required = parameterAnnotation.required();
                CommandParameterSuggester suggester = InjectionHelper.createWithConstructorInjection(suggesterClass, context);
                if (type.isArray()) {
                    Class<?> childType = type.getComponentType();
                    return CommandParameter.array(name, childType, required, suggester, context);
                }
                return CommandParameter.single(name, type, required, suggester, context);
            }
            if (!(annotation instanceof Game)) continue;
            return MarkerParameters.GAME;
        }
        return MarkerParameters.INVALID;
    }

    @Override
    protected List<Parameter> constructParameters(Context context) {
        SpecificAccessibleObject<Method> specificExecutionMethod = this.getExecutionMethod();
        Method executionMethod = specificExecutionMethod.getAccessibleObject();
        Class<?>[] methodParameters = executionMethod.getParameterTypes();
        Annotation[][] methodParameterAnnotations = executionMethod.getParameterAnnotations();
        ArrayList parameters = Lists.newArrayListWithExpectedSize((int)methodParameters.length);
        for (int i = 0; i < methodParameters.length; ++i) {
            parameters.add(MethodCommand.getParameterTypeFor(methodParameters[i], methodParameterAnnotations[i], context));
        }
        return parameters;
    }
}

