/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.console.adapter;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.destinationsol.SolApplication;
import org.destinationsol.game.console.adapter.HullConfigAdapter;
import org.destinationsol.game.console.adapter.ParameterAdapter;
import org.destinationsol.game.console.adapter.PositionFormatAdapter;
import org.destinationsol.game.console.adapter.PrimitiveAdapters;
import org.destinationsol.game.console.commands.PositionCommandHandler;
import org.destinationsol.game.ship.hulls.HullConfig;

public class ParameterAdapterManager {
    private final Map<Class<?>, ParameterAdapter> adapters = Maps.newHashMap();

    public static ParameterAdapterManager createBasic() {
        ParameterAdapterManager manager = new ParameterAdapterManager();
        for (Map.Entry entry : PrimitiveAdapters.MAP.entrySet()) {
            manager.registerAdapter((Class)entry.getKey(), (ParameterAdapter)entry.getValue());
        }
        return manager;
    }

    public static ParameterAdapterManager createCore(SolApplication application) {
        ParameterAdapterManager manager = ParameterAdapterManager.createBasic();
        manager.registerAdapter(PositionCommandHandler.PositionFormat.class, new PositionFormatAdapter());
        manager.registerAdapter(HullConfig.class, new HullConfigAdapter(application));
        return manager;
    }

    public <T> boolean registerAdapter(Class<? extends T> clazz, ParameterAdapter<T> adapter) {
        return this.adapters.put(clazz, adapter) == null;
    }

    public boolean isAdapterRegistered(Class<?> clazz) {
        return this.adapters.containsKey(clazz);
    }

    public <T> T parse(Class<T> clazz, String raw) throws ClassCastException {
        Preconditions.checkNotNull((Object)raw, (Object)"The String to parse must not be null");
        ParameterAdapter adapter = this.getAdapter(clazz);
        Preconditions.checkNotNull((Object)adapter, (Object)("No adapter found for " + clazz.getCanonicalName()));
        return adapter.parse(raw);
    }

    public <T> String convertToString(T value, Class<? super T> clazz) throws ClassCastException {
        Preconditions.checkNotNull(value, (Object)"The Object to convertToString must not be null");
        ParameterAdapter adapter = this.getAdapter(clazz);
        Preconditions.checkNotNull((Object)adapter, (Object)("No adapter found for " + clazz.getCanonicalName()));
        return adapter.convertToString(value);
    }

    public String convertToString(Object value) throws ClassCastException {
        Class<?> clazz = value.getClass();
        return this.convertToString(value, clazz);
    }

    public ParameterAdapter getAdapter(Class<?> clazz) {
        return this.adapters.get(clazz);
    }
}

