/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.console.commands;

import org.destinationsol.game.Hero;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.console.annotations.Command;
import org.destinationsol.game.console.annotations.CommandParam;
import org.destinationsol.game.console.annotations.Game;
import org.destinationsol.game.console.annotations.RegisterCommands;
import org.destinationsol.game.console.exceptions.CommandExecutionException;
import org.destinationsol.game.console.suggesters.HullConfigSuggester;
import org.destinationsol.game.ship.ShipRepairer;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.game.ship.hulls.HullConfig;

@RegisterCommands
public class ChangeShipCommandHandler {
    @Command(shortDescription="changes hero ship")
    public String changeShip(@Game SolGame game, @CommandParam(value="newShip", suggester=HullConfigSuggester.class) HullConfig hullConfig) throws CommandExecutionException {
        if (hullConfig == null) {
            throw new CommandExecutionException("Could not find such ship");
        }
        Hero hero = game.getHero();
        SolShip newShip = this.cloneAndModifyShip(hero.getShip(), game, hullConfig);
        game.getObjectManager().removeObjDelayed(hero.getShip());
        game.getObjectManager().addObjDelayed(newShip);
        hero.setSolShip(newShip, game);
        return "Ship changed";
    }

    private SolShip cloneAndModifyShip(SolShip originalShip, SolGame game, HullConfig newHullConfig) {
        SolShip newShip = game.getShipBuilder().build(game, originalShip.getPosition(), originalShip.getVelocity(), originalShip.getAngle(), originalShip.getRotationSpeed(), originalShip.getPilot(), originalShip.getItemContainer(), newHullConfig, newHullConfig.getMaxLife(), originalShip.getHull().getGun(false), originalShip.getHull().getGun(true), null, newHullConfig.getEngineConfig().exampleEngine.copy(), new ShipRepairer(), originalShip.getMoney(), null, originalShip.getShield(), originalShip.getArmor());
        return newShip;
    }
}

