/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.console.commands;

import org.destinationsol.game.DmgType;
import org.destinationsol.game.Hero;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.console.annotations.Command;
import org.destinationsol.game.console.annotations.Game;
import org.destinationsol.game.console.annotations.RegisterCommands;
import org.destinationsol.game.console.exceptions.CommandExecutionException;

@RegisterCommands
public class DieCommandHandler {
    @Command(shortDescription="Kills the hero")
    public String die(@Game SolGame game) throws CommandExecutionException {
        Hero hero = game.getHero();
        if (hero.isTranscendent()) {
            throw new CommandExecutionException("Cannot kill hero when transcendent!");
        }
        if (!hero.isAlive()) {
            throw new CommandExecutionException("Hero is already dead!");
        }
        hero.getShip().receivePiercingDmg((float)hero.getHull().getHullConfig().getMaxLife() + 1.0f, game, hero.getPosition(), DmgType.CRASH);
        return "Hero killed!";
    }
}

