/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.console.commands;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.console.Console;
import org.destinationsol.game.console.ConsoleCommand;
import org.destinationsol.game.console.annotations.Command;
import org.destinationsol.game.console.annotations.CommandParam;
import org.destinationsol.game.console.annotations.Game;
import org.destinationsol.game.console.annotations.RegisterCommands;
import org.destinationsol.game.console.suggesters.CommandNameSuggester;

@RegisterCommands
public class HelpCommandHandler {
    @Command(shortDescription="Prints out short descriptions for all available commands, or a longer help text if a command is provided.")
    public String help(@Game SolGame game, @CommandParam(value="command", required=false, suggester=CommandNameSuggester.class) String commandName) {
        Console console = game.getScreens().consoleScreen.getConsole();
        if (commandName == null) {
            StringBuilder msg = new StringBuilder();
            ImmutableList commands = Ordering.natural().immutableSortedCopy(console.getCommands());
            for (ConsoleCommand cmd : commands) {
                if (!msg.toString().isEmpty()) {
                    msg.append("\n");
                }
                msg.append(cmd.getUsage());
                msg.append(" - ");
                msg.append(cmd.getDescription());
            }
            return msg.toString();
        }
        ConsoleCommand cmd = console.getCommand(commandName);
        if (cmd == null) {
            return "No help available for command '" + commandName + "'. Unknown command.";
        }
        StringBuilder msg = new StringBuilder();
        msg.append("=====================================================================");
        msg.append("\n");
        msg.append(cmd.getUsage());
        msg.append("\n");
        msg.append("=====================================================================");
        msg.append("\n");
        if (!cmd.getHelpText().isEmpty()) {
            msg.append(cmd.getHelpText());
            msg.append("\n");
            msg.append("=====================================================================");
            msg.append("\n");
        } else if (!cmd.getDescription().isEmpty()) {
            msg.append(cmd.getDescription());
            msg.append("\n");
            msg.append("=====================================================================");
            msg.append("\n");
        }
        return msg.toString();
    }
}

