/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.console.commands;

import org.destinationsol.game.Hero;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.console.annotations.Command;
import org.destinationsol.game.console.annotations.Game;
import org.destinationsol.game.console.annotations.RegisterCommands;
import org.destinationsol.game.console.exceptions.CommandExecutionException;

@RegisterCommands
public class InvincibleCommandHandler {
    @Command(shortDescription="Makes the hero invincible")
    public String godMode(@Game SolGame game) throws CommandExecutionException {
        Hero hero = game.getHero();
        if (hero.isDead()) {
            throw new CommandExecutionException("Cannot make invincible when dead");
        }
        if (hero.isTranscendent()) {
            throw new CommandExecutionException("Cannot make invincible when transdencent");
        }
        if (!hero.isInvincible()) {
            hero.setInvincible(true);
            return "Set player as invincible";
        }
        hero.setInvincible(false);
        return "Set player as non invincible";
    }
}

