/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.console.commands;

import com.badlogic.gdx.math.Vector2;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.console.annotations.Command;
import org.destinationsol.game.console.annotations.CommandParam;
import org.destinationsol.game.console.annotations.Game;
import org.destinationsol.game.console.annotations.RegisterCommands;
import org.destinationsol.game.console.suggesters.PositionFormatSuggester;

@RegisterCommands
public class PositionCommandHandler {
    private static final char BOLD_LINE_CHARACTER = '*';
    private static final int BOLD_EXTRA_CHARACTERS = 6;

    @Command(shortDescription="Prints the hero position")
    public String position(@Game SolGame game, @CommandParam(value="format", required=false, suggester=PositionFormatSuggester.class) PositionFormat format) {
        if (format == null) {
            format = PositionFormat.INTERNAL;
        }
        Vector2 heroPosition = game.getHero().getPosition();
        switch (format) {
            case TERSE: {
                return "X: " + heroPosition.x + "   Y: " + heroPosition.y;
            }
            case VERBOSE: {
                return "The hero's X co-ordinate is: " + heroPosition.x + "\nThe hero's Y co-ordinate is: " + heroPosition.y;
            }
            case BOLD: {
                return this.getBoldFormat(heroPosition);
            }
            case INTERNAL: {
                return heroPosition.toString();
            }
        }
        return heroPosition.toString();
    }

    private String getBoldFormat(Vector2 heroPosition) {
        String xOutputString = "X: " + heroPosition.x;
        String yOutputString = "Y: " + heroPosition.y;
        StringBuilder boldLine = new StringBuilder();
        int boldLineLength = Math.max(xOutputString.length(), yOutputString.length());
        for (int i = 0; i < boldLineLength + 6; ++i) {
            boldLine.append('*');
        }
        String format = boldLine.toString() + "\n" + xOutputString + "\n" + yOutputString + "\n" + boldLine.toString();
        return format;
    }

    public static enum PositionFormat {
        TERSE,
        VERBOSE,
        BOLD,
        INTERNAL;

    }
}

