/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.console.suggesters;

import java.util.HashSet;
import java.util.Set;
import org.destinationsol.assets.Assets;
import org.destinationsol.assets.json.Json;
import org.destinationsol.common.SolException;
import org.destinationsol.files.HullConfigManager;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.console.CommandParameterSuggester;
import org.destinationsol.game.ship.hulls.HullConfig;
import org.terasology.gestalt.assets.ResourceUrn;

public class HullConfigSuggester
implements CommandParameterSuggester<HullConfig> {
    @Override
    public Set<HullConfig> suggest(SolGame game, Object ... resolvedParameters) {
        HashSet<HullConfig> suggestions = new HashSet<HullConfig>();
        HullConfigManager hullConfigManager = game.getHullConfigManager();
        for (ResourceUrn urn : Assets.getAssetHelper().list(Json.class)) {
            HullConfig config;
            try {
                config = hullConfigManager.getConfig(urn.getModuleName() + ":" + urn.getResourceName());
            }
            catch (SolException e) {
                continue;
            }
            if (config.getType() == HullConfig.Type.STATION) continue;
            suggestions.add(config);
        }
        return suggestions;
    }
}

