/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.drawables;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import java.util.HashSet;
import java.util.Set;
import org.destinationsol.common.DebugCol;
import org.destinationsol.common.SolColor;
import org.destinationsol.game.DebugOptions;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.UpdateAwareSystem;
import org.destinationsol.ui.UiDrawer;

public class DrawableDebugger
implements UpdateAwareSystem {
    private static final float TEX_SZ = 0.1f;
    private static final float GAP = 0.01f;
    private final Set<TextureAtlas.AtlasRegion> textures = new HashSet<TextureAtlas.AtlasRegion>();

    @Override
    public void update(SolGame game, float timeStep) {
        if (!DebugOptions.TEX_INFO) {
            return;
        }
        this.maybeCollectTextures(game);
    }

    private void maybeCollectTextures(SolGame game) {
        if (!Gdx.input.isTouched()) {
            return;
        }
        this.textures.clear();
        Vector2 cursorPosition = new Vector2((float)Gdx.input.getX(), (float)Gdx.input.getY());
        game.getCam().screenToWorld(cursorPosition);
        game.getDrawableManager().collectTextures(this.textures, cursorPosition);
    }

    public void draw(UiDrawer uiDrawer) {
        if (!DebugOptions.TEX_INFO) {
            return;
        }
        float y = 0.01f;
        for (TextureAtlas.AtlasRegion texture : this.textures) {
            float x = 0.01f;
            uiDrawer.draw(UiDrawer.whiteTexture, 0.5f, 0.120000005f, 0.0f, 0.0f, x, y, 0.0f, SolColor.DG);
            float dimensionsRatio = 1.0f * (float)texture.getTexture().getWidth() / (float)texture.getTexture().getHeight();
            float width = dimensionsRatio > 1.0f ? 0.1f : 0.1f / dimensionsRatio;
            float height = dimensionsRatio > 1.0f ? 0.1f / dimensionsRatio : 0.1f;
            uiDrawer.draw((TextureRegion)texture, width, height, width / 2.0f, height / 2.0f, (x += 0.01f) + 0.05f, (y += 0.01f) + 0.05f, 0.0f, SolColor.WHITE);
            uiDrawer.drawString(texture.name, x += 0.11f, y, 0.5f, false, DebugCol.TEX_INFO);
            y += 0.05f;
        }
    }
}

