/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.drawables;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.OrderedMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.destinationsol.common.DebugCol;
import org.destinationsol.game.DebugOptions;
import org.destinationsol.game.GameDrawer;
import org.destinationsol.game.MapDrawer;
import org.destinationsol.game.ObjectManager;
import org.destinationsol.game.SolCam;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.drawables.DrawableLevel;

public class DrawableManager {
    private final DrawableLevel[] drawableLevels;
    private final ArrayList<OrderedMap<Texture, List<Drawable>>> drawables;
    private final Set<Drawable> visibleDrawables = new HashSet<Drawable>();
    private final GameDrawer drawer;

    public DrawableManager(GameDrawer drawer) {
        this.drawableLevels = DrawableLevel.values();
        this.drawer = drawer;
        this.drawables = new ArrayList();
        for (DrawableLevel ignored : this.drawableLevels) {
            this.drawables.add((OrderedMap<Texture, List<Drawable>>)new OrderedMap());
        }
    }

    public static float radiusFromDrawables(List<Drawable> drawables) {
        float radius = 0.0f;
        for (Drawable drawable : drawables) {
            float relativeRadius = drawable.getRelativePosition().len() + drawable.getRadius();
            if (!(radius < relativeRadius)) continue;
            radius = relativeRadius;
        }
        return radius;
    }

    public void removeObject(SolObject o) {
        List<Drawable> drawables = o.getDrawables();
        this.removeAll(drawables);
    }

    public void removeAll(List<Drawable> drawables) {
        for (Drawable drawable : drawables) {
            Texture texture;
            DrawableLevel level = drawable.getLevel();
            OrderedMap<Texture, List<Drawable>> map = this.drawables.get(level.ordinal());
            List set = (List)map.get((Object)(texture = drawable.getTexture().getTexture()));
            if (set == null) continue;
            set.remove(drawable);
            this.visibleDrawables.remove(drawable);
        }
    }

    public void addObject(SolObject o) {
        List<Drawable> drawables = o.getDrawables();
        this.addAll(drawables);
    }

    public void addAll(List<Drawable> drawables) {
        for (Drawable drawable : drawables) {
            Texture texture;
            DrawableLevel level = drawable.getLevel();
            OrderedMap<Texture, List<Drawable>> map = this.drawables.get(level.ordinal());
            ArrayList<Drawable> set = (ArrayList<Drawable>)map.get((Object)(texture = drawable.getTexture().getTexture()));
            if (set == null) {
                set = new ArrayList<Drawable>();
                map.put((Object)texture, set);
            }
            if (set.contains(drawable)) continue;
            set.add(drawable);
            this.visibleDrawables.remove(drawable);
        }
    }

    public void draw(SolGame game) {
        MapDrawer mapDrawer = game.getMapDrawer();
        if (mapDrawer.isToggled()) {
            mapDrawer.draw(this.drawer, game);
            return;
        }
        SolCam cam = game.getCam();
        this.drawer.updateMatrix(game);
        game.getFarBackgroundgManagerOld().draw(this.drawer, cam, game);
        Vector2 camPos = cam.getPosition();
        float viewDistance = cam.getViewDistance();
        ObjectManager objectManager = game.getObjectManager();
        List<SolObject> objects = objectManager.getObjects();
        for (SolObject object : objects) {
            Vector2 objectPosition = object.getPosition();
            float radius = objectManager.getPresenceRadius(object);
            List<Drawable> drawables = object.getDrawables();
            float drawableLevelViewDistance = viewDistance;
            if (drawables.size() > 0) {
                drawableLevelViewDistance *= drawables.get((int)0).getLevel().depth;
            }
            boolean isObjectVisible = this.isVisible(objectPosition, radius, camPos, drawableLevelViewDistance);
            for (Drawable drawable : drawables) {
                if (!isObjectVisible || !drawable.isEnabled()) {
                    this.visibleDrawables.remove(drawable);
                    continue;
                }
                drawable.prepare(object);
                Vector2 draPos = drawable.getPosition();
                float rr = drawable.getRadius();
                boolean draInCam = this.isVisible(draPos, rr, camPos, drawableLevelViewDistance);
                if (draInCam) {
                    this.visibleDrawables.add(drawable);
                    continue;
                }
                this.visibleDrawables.remove(drawable);
            }
        }
        int dlCount = this.drawableLevels.length;
        for (int dlIdx = 0; dlIdx < dlCount; ++dlIdx) {
            DrawableLevel drawableLevel = this.drawableLevels[dlIdx];
            if (drawableLevel == DrawableLevel.PART_FG_0) {
                game.getMountDetectDrawer().draw(this.drawer);
            }
            OrderedMap<Texture, List<Drawable>> map = this.drawables.get(dlIdx);
            Array texs = map.orderedKeys();
            int sz = texs.size;
            for (int texIdx = 0; texIdx < sz; ++texIdx) {
                Texture tex = (Texture)texs.get(texIdx);
                List drawables = (List)map.get((Object)tex);
                for (Drawable drawable : drawables) {
                    if (!this.visibleDrawables.contains(drawable) || DebugOptions.NO_DRAS) continue;
                    drawable.draw(this.drawer, game);
                }
            }
            if (drawableLevel.depth <= 1.0f) {
                game.drawDebug(this.drawer);
            }
            if (drawableLevel != DrawableLevel.ATM || DebugOptions.NO_DRAS) continue;
            game.getPlanetManager().drawPlanetCoreHack(game, this.drawer);
            game.getPlanetManager().drawSunHack(game, this.drawer);
        }
        if (DebugOptions.DRAW_DRA_BORDERS) {
            for (OrderedMap<Texture, List<Drawable>> map : this.drawables) {
                for (List drawables : map.values()) {
                    for (Drawable drawable : drawables) {
                        this.drawDebug(this.drawer, game, drawable);
                    }
                }
            }
        }
        game.getSoundManager().drawDebug(this.drawer, game);
        this.drawer.maybeChangeAdditive(false);
    }

    private void drawDebug(GameDrawer drawer, SolGame game, Drawable drawable) {
        SolCam cam = game.getCam();
        float lineWidth = cam.getRealLineWidth();
        Color col = this.visibleDrawables.contains(drawable) ? DebugCol.DRA : DebugCol.DRA_OUT;
        Vector2 position = drawable.getPosition();
        drawer.drawCircle((TextureRegion)drawer.debugWhiteTexture, position, drawable.getRadius(), col, lineWidth, cam.getViewHeight());
    }

    private boolean isVisible(Vector2 position, float radius, Vector2 camPosition, float viewDistance) {
        return camPosition.dst(position) - viewDistance < radius;
    }

    public boolean isVisible(Drawable drawable) {
        return this.visibleDrawables.contains(drawable);
    }

    public void collectTextures(Collection<TextureAtlas.AtlasRegion> collector, Vector2 position) {
        for (Drawable drawable : this.visibleDrawables) {
            TextureAtlas.AtlasRegion tex;
            if (0.5f * drawable.getRadius() < drawable.getPosition().dst(position) || (tex = drawable.getTexture()) == null) continue;
            collector.add(tex);
        }
    }
}

