/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.drawables;

import com.badlogic.gdx.math.Vector2;
import java.util.List;
import org.destinationsol.common.Consumed;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.DmgType;
import org.destinationsol.game.FarObject;
import org.destinationsol.game.RemoveController;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.drawables.DrawableManager;
import org.destinationsol.game.drawables.FarDrawable;
import org.destinationsol.game.drawables.RectSprite;
import org.destinationsol.game.planet.Planet;

public class DrawableObject
implements SolObject {
    private final Vector2 position;
    private final Vector2 velocity;
    private final RemoveController removeController;
    private final boolean hideOnPlanet;
    private final Vector2 moveDifference;
    private final List<Drawable> drawables;
    private final boolean isTemporary;
    private float maxFadeTime;
    private float fadeTime;

    public DrawableObject(List<Drawable> drawables, @Consumed Vector2 position, @Consumed Vector2 velocity, RemoveController removeController, boolean temporary, boolean hideOnPlanet) {
        this.drawables = drawables;
        this.position = position;
        this.velocity = velocity;
        this.removeController = removeController;
        this.hideOnPlanet = hideOnPlanet;
        this.moveDifference = new Vector2();
        this.isTemporary = temporary;
        this.maxFadeTime = -1.0f;
        this.fadeTime = -1.0f;
    }

    @Override
    public void update(SolGame game) {
        block3: {
            float timeStep;
            block2: {
                this.moveDifference.set(this.velocity);
                timeStep = game.getTimeStep();
                this.moveDifference.scl(timeStep);
                this.position.add(this.moveDifference);
                if (!this.hideOnPlanet) break block2;
                Planet planet = game.getPlanetManager().getNearestPlanet();
                Vector2 planetPosition = planet.getPosition();
                float planetGroundHeight = planet.getGroundHeight();
                DrawableManager drawableManager = game.getDrawableManager();
                for (Drawable drawable : this.drawables) {
                    if (!(drawable instanceof RectSprite) || !drawableManager.isVisible(drawable)) continue;
                    Vector2 drawablePosition = drawable.getPosition();
                    float gradSz = 3.5f;
                    float distPercentage = (drawablePosition.dst(planetPosition) - planetGroundHeight - 14.0f) / gradSz;
                    ((RectSprite)drawable).tint.a = distPercentage = SolMath.clamp(distPercentage);
                }
                break block3;
            }
            if (!(this.maxFadeTime > 0.0f)) break block3;
            this.fadeTime -= timeStep;
            float tintPercentage = this.fadeTime / this.maxFadeTime;
            for (Drawable drawable : this.drawables) {
                if (!(drawable instanceof RectSprite)) continue;
                RectSprite rectSprite = (RectSprite)drawable;
                rectSprite.tint.a = SolMath.clamp(tintPercentage * rectSprite.baseAlpha);
            }
        }
    }

    @Override
    public boolean shouldBeRemoved(SolGame game) {
        if (this.maxFadeTime > 0.0f && this.fadeTime <= 0.0f) {
            return true;
        }
        if (this.isTemporary) {
            boolean rem = true;
            for (Drawable drawable : this.drawables) {
                if (drawable.okToRemove()) continue;
                rem = false;
                break;
            }
            if (rem) {
                return true;
            }
        }
        return this.removeController != null && this.removeController.shouldRemove(this.position);
    }

    @Override
    public void onRemove(SolGame game) {
    }

    @Override
    public void receiveDmg(float dmg, SolGame game, Vector2 position, DmgType dmgType) {
    }

    @Override
    public boolean receivesGravity() {
        return false;
    }

    @Override
    public void receiveForce(Vector2 force, SolGame game, boolean acc) {
    }

    @Override
    public Vector2 getPosition() {
        return this.position;
    }

    @Override
    public FarObject toFarObject() {
        return this.isTemporary ? null : new FarDrawable(this.drawables, this.position, this.velocity, this.removeController, this.hideOnPlanet);
    }

    @Override
    public List<Drawable> getDrawables() {
        return this.drawables;
    }

    @Override
    public float getAngle() {
        return 0.0f;
    }

    @Override
    public Vector2 getVelocity() {
        return null;
    }

    @Override
    public void handleContact(SolObject other, float absImpulse, SolGame game, Vector2 collPos) {
    }

    @Override
    public String toDebugString() {
        return null;
    }

    @Override
    public Boolean isMetal() {
        return null;
    }

    @Override
    public boolean hasBody() {
        return false;
    }

    public void fade(float fadeTime) {
        this.maxFadeTime = fadeTime;
        this.fadeTime = fadeTime;
    }
}

