/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.drawables;

import com.badlogic.gdx.math.Vector2;
import java.util.List;
import org.destinationsol.game.FarObject;
import org.destinationsol.game.RemoveController;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.drawables.DrawableManager;
import org.destinationsol.game.drawables.DrawableObject;

public class FarDrawable
implements FarObject {
    private final List<Drawable> drawables;
    private final Vector2 position;
    private final Vector2 velocity;
    private final RemoveController removeController;
    private final float radius;
    private final boolean hideOnPlanet;

    public FarDrawable(List<Drawable> drawables, Vector2 position, Vector2 velocity, RemoveController removeController, boolean hideOnPlanet) {
        this.drawables = drawables;
        this.position = position;
        this.velocity = velocity;
        this.removeController = removeController;
        this.radius = DrawableManager.radiusFromDrawables(this.drawables);
        this.hideOnPlanet = hideOnPlanet;
    }

    @Override
    public boolean shouldBeRemoved(SolGame game) {
        return this.removeController != null && this.removeController.shouldRemove(this.position);
    }

    @Override
    public SolObject toObject(SolGame game) {
        return new DrawableObject(this.drawables, this.position, this.velocity, this.removeController, false, this.hideOnPlanet);
    }

    @Override
    public void update(SolGame game) {
    }

    @Override
    public float getRadius() {
        return this.radius;
    }

    @Override
    public Vector2 getPosition() {
        return this.position;
    }

    @Override
    public String toDebugString() {
        return null;
    }

    @Override
    public boolean hasBody() {
        return false;
    }

    public List<Drawable> getDrawables() {
        return this.drawables;
    }
}

