/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.drawables;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import org.destinationsol.common.Consumed;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.GameDrawer;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.drawables.DrawableLevel;

public class RectSprite
implements Drawable {
    public final Vector2 relativePosition;
    public final Color tint;
    private final float originalPercentageX;
    private final float originalPercentageY;
    private final DrawableLevel level;
    private final Vector2 position;
    private final float rotationSpeed;
    private final boolean isAdditive;
    public float relativeAngle;
    public float baseAlpha;
    protected TextureAtlas.AtlasRegion texture;
    private float textureSizeX;
    private float textureSizeY;
    private float originalX;
    private float originalY;
    private float radius;
    private float angle;
    private boolean isEnabled;

    public RectSprite(TextureAtlas.AtlasRegion tex, float texSz, float origPercX, float origPercY, @Consumed Vector2 relativePosition, DrawableLevel level, float relativeAngle, float rotationSpeed, Color tint, boolean additive) {
        if (tex == null) {
            throw new AssertionError((Object)"tex is null");
        }
        this.texture = tex;
        this.originalPercentageX = origPercX;
        this.originalPercentageY = origPercY;
        this.relativePosition = relativePosition;
        this.position = new Vector2();
        this.level = level;
        this.relativeAngle = relativeAngle;
        this.rotationSpeed = rotationSpeed;
        this.isEnabled = true;
        this.baseAlpha = tint.a;
        this.tint = new Color(tint);
        this.setTextureSize(texSz);
        this.isAdditive = additive;
    }

    public void setTextureSize(float textureSize) {
        textureSize /= this.level.depth;
        int dimensionsRatio = this.texture.getRegionWidth() / this.texture.getRegionHeight();
        if (dimensionsRatio > 1) {
            this.textureSizeX = textureSize;
            this.textureSizeY = textureSize / (float)dimensionsRatio;
        } else {
            this.textureSizeX = textureSize / (float)dimensionsRatio;
            this.textureSizeY = textureSize;
        }
        this.originalX = this.textureSizeX / 2.0f + textureSize * this.originalPercentageX;
        this.originalY = this.textureSizeY / 2.0f + textureSize * this.originalPercentageY;
        float relativeX = this.textureSizeX / 2.0f + textureSize * SolMath.abs(this.originalPercentageX);
        float relativeY = this.textureSizeY / 2.0f + textureSize * SolMath.abs(this.originalPercentageY);
        this.radius = SolMath.sqrt(relativeX * relativeX + relativeY * relativeY);
    }

    @Override
    public TextureAtlas.AtlasRegion getTexture() {
        return this.texture;
    }

    @Override
    public DrawableLevel getLevel() {
        return this.level;
    }

    @Override
    public void update(SolGame game, SolObject o) {
        this.relativeAngle += this.rotationSpeed * game.getTimeStep();
    }

    @Override
    public void prepare(SolObject object) {
        float baseAngle = object.getAngle();
        Vector2 basePosition = object.getPosition();
        SolMath.toWorld(this.position, this.relativePosition, baseAngle, basePosition);
        this.angle = this.relativeAngle + baseAngle;
    }

    @Override
    public Vector2 getPosition() {
        return this.position;
    }

    @Override
    public Vector2 getRelativePosition() {
        return this.relativePosition;
    }

    @Override
    public float getRadius() {
        return this.radius;
    }

    @Override
    public void draw(GameDrawer drawer, SolGame game) {
        float x = this.position.x;
        float y = this.position.y;
        if (this.level.depth != 1.0f) {
            Vector2 camPosition = game.getCam().getPosition();
            x = (x - camPosition.x) / this.level.depth + camPosition.x;
            y = (y - camPosition.y) / this.level.depth + camPosition.y;
        }
        if (this.isAdditive) {
            drawer.drawAdditive((TextureRegion)this.texture, this.textureSizeX, this.textureSizeY, this.originalX, this.originalY, x, y, this.angle, this.tint);
        } else {
            drawer.draw((TextureRegion)this.texture, this.textureSizeX, this.textureSizeY, this.originalX, this.originalY, x, y, this.angle, this.tint);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    @Override
    public boolean okToRemove() {
        return true;
    }
}

