/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.drawables;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import java.util.HashMap;
import java.util.Map;
import org.destinationsol.assets.Assets;
import org.destinationsol.game.drawables.DrawableLevel;
import org.destinationsol.game.drawables.RectSprite;
import org.destinationsol.game.drawables.SpriteInfo;
import org.destinationsol.game.drawables.animated.AnimatedRectSprite;

public final class SpriteManager {
    private static Map<String, SpriteInfo> sprites = new HashMap<String, SpriteInfo>();

    private SpriteManager() {
    }

    public static RectSprite createSprite(String name, DrawableLevel drawLevel) {
        return SpriteManager.createSprite(name, 1.0f, 0.0f, 0.0f, new Vector2(), drawLevel, 0.0f, 0.0f, Color.WHITE, false);
    }

    public static RectSprite createSprite(String name, DrawableLevel drawLevel, Vector2 relativePosition) {
        return SpriteManager.createSprite(name, 1.0f, 0.0f, 0.0f, relativePosition, drawLevel, 0.0f, 0.0f, Color.WHITE, false);
    }

    public static RectSprite createSprite(String name, DrawableLevel drawLevel, Vector2 relativePosition, Color color) {
        return SpriteManager.createSprite(name, 1.0f, 0.0f, 0.0f, relativePosition, drawLevel, 0.0f, 0.0f, color, false);
    }

    public static RectSprite createSprite(String name, DrawableLevel drawLevel, Vector2 relativePosition, Color color, boolean additive) {
        return SpriteManager.createSprite(name, 1.0f, 0.0f, 0.0f, relativePosition, drawLevel, 0.0f, 0.0f, color, additive);
    }

    public static RectSprite createSprite(String name, float size, float originalXPercentage, float originalYPercentage, Vector2 relativePosition, DrawableLevel drawLevel, float angle, float rotateSpeed, Color tint, boolean additive) {
        SpriteInfo sprite;
        if (!sprites.containsKey(name)) {
            try {
                Animation<TextureAtlas.AtlasRegion> frames = Assets.getAnimation(name);
                sprite = new SpriteInfo(name, frames);
                sprites.put(name, sprite);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("There is no sprite called \"" + name + "\"!");
            }
        } else {
            sprite = sprites.get(name);
        }
        return new AnimatedRectSprite(sprite.frames, size, originalXPercentage, originalYPercentage, relativePosition, drawLevel, angle, rotateSpeed, tint, additive);
    }

    public static RectSprite createStaticSprite(TextureAtlas.AtlasRegion texture, float size, float originalXPercentage, float originalYPercentage, Vector2 relativePosition, DrawableLevel drawLevel, float angle, float rotateSpeed, Color tint, boolean additive) {
        return new RectSprite(texture, size, originalXPercentage, originalYPercentage, relativePosition, drawLevel, angle, rotateSpeed, tint, additive);
    }

    public static AnimatedRectSprite createAnimatedSprite(TextureAtlas.AtlasRegion initialRegion, int frameWidth, int frameHeight, float framesPerSecond, int frameCount, float size, float originalXPercentage, float originalYPercentage, Vector2 relativePosition, DrawableLevel drawLevel, float angle, float rotateSpeed, Color tint, boolean additive) {
        Object[] regions = SpriteManager.getSequentialRegions(initialRegion, frameCount, frameWidth, frameHeight);
        Animation animation = new Animation(1.0f / framesPerSecond, regions);
        return SpriteManager.createAnimatedSprite((Animation<TextureAtlas.AtlasRegion>)animation, size, originalXPercentage, originalYPercentage, relativePosition, drawLevel, angle, rotateSpeed, tint, additive);
    }

    public static AnimatedRectSprite createAnimatedSprite(Animation<TextureAtlas.AtlasRegion> animation, float size, float originalXPercentage, float originalYPercentage, Vector2 relativePosition, DrawableLevel drawLevel, float angle, float rotateSpeed, Color tint, boolean additive) {
        return new AnimatedRectSprite(animation, size, originalXPercentage, originalYPercentage, relativePosition, drawLevel, angle, rotateSpeed, tint, additive);
    }

    public static TextureAtlas.AtlasRegion[] getSequentialRegions(TextureAtlas.AtlasRegion initialRegion, int regionCount, int sequentialWidth, int sequentialHeight) {
        Texture texture = initialRegion.getTexture();
        int textureWidth = texture.getWidth();
        TextureAtlas.AtlasRegion[] regions = new TextureAtlas.AtlasRegion[regionCount];
        for (int i = 0; i < regionCount; ++i) {
            int x = i * sequentialWidth % textureWidth;
            int y = i * sequentialWidth / textureWidth * sequentialHeight;
            regions[i] = new TextureAtlas.AtlasRegion(texture, x, y, sequentialWidth, sequentialHeight);
            regions[i].flip(false, true);
            regions[i].name = initialRegion.name + " frame " + i;
        }
        return regions;
    }
}

