/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.drawables.animated;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import org.destinationsol.common.Consumed;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.drawables.DrawableLevel;
import org.destinationsol.game.drawables.RectSprite;

public class AnimatedRectSprite
extends RectSprite {
    private Animation<TextureAtlas.AtlasRegion> spriteAnimation;
    private float animationTime;

    public AnimatedRectSprite(Animation<TextureAtlas.AtlasRegion> animation, float texSz, float origPercX, float origPercY, @Consumed Vector2 relativePosition, DrawableLevel level, float relativeAngle, float rotationSpeed, Color tint, boolean additive) {
        super((TextureAtlas.AtlasRegion)animation.getKeyFrame(0.0f), texSz, origPercX, origPercY, relativePosition, level, relativeAngle, rotationSpeed, tint, additive);
        this.spriteAnimation = animation;
    }

    @Override
    public void update(SolGame game, SolObject object) {
        super.update(game, object);
        this.animationTime += game.getTimeStep();
        this.texture = (TextureAtlas.AtlasRegion)this.spriteAnimation.getKeyFrame(this.animationTime, true);
    }

    public float getAnimationTime() {
        return this.animationTime;
    }

    public void setAnimationTime(float time) {
        this.animationTime = time;
    }

    public Animation<TextureAtlas.AtlasRegion> getAnimation() {
        return this.spriteAnimation;
    }

    public void setAnimation(Animation<TextureAtlas.AtlasRegion> animation) {
        this.spriteAnimation = animation;
    }
}

