/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.farBg;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import org.destinationsol.assets.Assets;
import org.destinationsol.common.SolColor;
import org.destinationsol.common.SolColorUtil;
import org.destinationsol.common.SolRandom;
import org.destinationsol.game.GameDrawer;
import org.destinationsol.game.SolCam;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.planet.Planet;

public class FarBackgroundManagerOld {
    private final TextureAtlas.AtlasRegion nebulaTexture;
    private final ArrayList<FarBackgroundStar> stars = new ArrayList();
    private final float nebulaAngle;
    private final Color nebulaTint;

    public FarBackgroundManagerOld() {
        this.nebulaTexture = Assets.getAtlasRegion("engine:farBgNebulae");
        if (SolRandom.test(0.5f)) {
            this.nebulaTexture.flip(this.nebulaTexture.isFlipX(), !this.nebulaTexture.isFlipY());
        }
        for (int i = 0; i < 400; ++i) {
            FarBackgroundStar star = new FarBackgroundStar();
            this.stars.add(star);
        }
        this.nebulaAngle = SolRandom.randomFloat(180.0f);
        this.nebulaTint = SolColor.col(0.5f, 1.0f);
    }

    public void draw(GameDrawer drawer, SolCam cam, SolGame game) {
        Planet np = game.getPlanetManager().getNearestPlanet();
        Vector2 camPos = cam.getPosition();
        float nebPercentage = (camPos.dst(np.getPosition()) - np.getGroundHeight()) / 56.0f;
        this.nebulaTint.a = nebPercentage = MathUtils.clamp((float)nebPercentage, (float)0.0f, (float)1.0f);
        float vd = cam.getViewDistance();
        drawer.draw((TextureRegion)this.nebulaTexture, vd * 2.0f, vd * 2.0f, vd, vd, camPos.x, camPos.y, this.nebulaAngle, this.nebulaTint);
        for (FarBackgroundStar star : this.stars) {
            star.draw(drawer, vd, camPos, cam.getAngle());
        }
    }

    private static class FarBackgroundStar {
        private final Vector2 myShiftPercentage = new Vector2(SolRandom.randomFloat(1.0f), SolRandom.randomFloat(1.0f));
        private final TextureAtlas.AtlasRegion myTexture;
        private final float mySzPercentage;
        private final Color myTint;
        private final Vector2 position = new Vector2();

        private FarBackgroundStar() {
            boolean small = SolRandom.test(0.8f);
            this.myTexture = Assets.getAtlasRegion("engine:farBgBigStar");
            this.mySzPercentage = (small ? 0.01f : 0.04f) * SolRandom.randomFloat(0.5f, 1.0f);
            this.myTint = new Color();
            SolColorUtil.fromHSB(SolRandom.randomFloat(0.0f, 1.0f), 0.25f, 1.0f, 0.7f, this.myTint);
        }

        public void draw(GameDrawer drawer, float vd, Vector2 camPos, float camAngle) {
            float sz = vd * this.mySzPercentage;
            this.position.set(this.myShiftPercentage).scl(vd).add(camPos);
            drawer.drawAdditive((TextureRegion)this.myTexture, sz, sz, sz / 2.0f, sz / 2.0f, this.position.x, this.position.y, camAngle, this.myTint);
        }
    }
}

