/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.gun;

import com.badlogic.gdx.math.Vector2;
import java.util.List;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.Faction;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.gun.SolGun;
import org.destinationsol.game.input.Shooter;
import org.destinationsol.game.item.Gun;
import org.destinationsol.game.item.ItemContainer;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.game.ship.hulls.GunSlot;
import org.destinationsol.game.ship.hulls.HullConfig;

public class GunMount {
    private final Vector2 myRelPos;
    private final boolean myFixed;
    private SolGun myGun;
    private boolean myDetected;
    private float myRelGunAngle;

    public GunMount(GunSlot gunSlot) {
        this.myRelPos = gunSlot.getPosition();
        this.myFixed = !gunSlot.allowsRotation();
    }

    public void update(ItemContainer ic, SolGame game, float shipAngle, SolShip creator, boolean shouldShoot, SolShip nearestEnemy, Faction faction) {
        if (this.myGun == null) {
            return;
        }
        if (!ic.contains(this.myGun.getItem())) {
            this.setGun(game, creator, null, false, 0);
            return;
        }
        if (creator.getHull().config.getType() != HullConfig.Type.STATION) {
            this.myRelGunAngle = 0.0f;
        }
        this.myDetected = false;
        if (!this.myFixed && nearestEnemy != null) {
            float detDst;
            Vector2 creatorPos = creator.getPosition();
            Vector2 nePos = nearestEnemy.getPosition();
            float dst = creatorPos.dst(nePos) - creator.getHull().config.getApproxRadius() - nearestEnemy.getHull().config.getApproxRadius();
            float f = detDst = game.getPlanetManager().getNearestPlanet().isNearGround(creatorPos) ? 1.12f : 3.6000001f;
            if (dst < detDst) {
                Vector2 mountPos = SolMath.toWorld(this.myRelPos, shipAngle, creatorPos);
                boolean player = creator.getPilot().isPlayer();
                float shootAngle = Shooter.calcShootAngle(mountPos, creator.getVelocity(), nePos, nearestEnemy.getVelocity(), this.myGun.getConfig().clipConf.projConfig.speed, player);
                if (shootAngle == shootAngle) {
                    this.myRelGunAngle = shootAngle - shipAngle;
                    this.myDetected = true;
                    if (player) {
                        game.getMountDetectDrawer().setNe(nearestEnemy);
                    }
                }
                SolMath.free(mountPos);
            }
        }
        float gunAngle = shipAngle + this.myRelGunAngle;
        this.myGun.update(ic, game, gunAngle, creator, shouldShoot, faction, creator);
    }

    public Gun getGun() {
        return this.myGun == null ? null : this.myGun.getItem();
    }

    public void setGun(SolGame game, SolObject o, Gun gun, boolean underShip, int slotNr) {
        List<Drawable> dras1;
        List<Drawable> drawables = o.getDrawables();
        if (this.myGun != null) {
            dras1 = this.myGun.getDrawables();
            drawables.removeAll(dras1);
            game.getDrawableManager().removeAll(dras1);
            this.myGun.getItem().setEquipped(0);
            this.myGun = null;
        }
        if (gun != null) {
            if (gun.config.fixed != this.myFixed) {
                throw new AssertionError((Object)"tried to set gun to incompatible mount");
            }
            this.myGun = new SolGun(gun, this.myRelPos, underShip);
            this.myGun.getItem().setEquipped(slotNr);
            dras1 = this.myGun.getDrawables();
            drawables.addAll(dras1);
            game.getDrawableManager().addAll(dras1);
        }
    }

    public boolean isFixed() {
        return this.myFixed;
    }

    public Vector2 getRelPos() {
        return this.myRelPos;
    }

    public boolean isDetected() {
        return this.myDetected;
    }
}

