/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.gun;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.common.SolColor;
import org.destinationsol.common.SolMath;
import org.destinationsol.common.SolRandom;
import org.destinationsol.game.Faction;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.drawables.DrawableLevel;
import org.destinationsol.game.drawables.RectSprite;
import org.destinationsol.game.drawables.SpriteManager;
import org.destinationsol.game.item.Clip;
import org.destinationsol.game.item.Gun;
import org.destinationsol.game.item.ItemContainer;
import org.destinationsol.game.particle.LightSource;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.projectile.Projectile;
import org.destinationsol.game.projectile.ProjectileConfig;
import org.destinationsol.game.ship.SolShip;

public class SolGun {
    private final LightSource myLightSource;
    private final Vector2 myRelPos;
    private final RectSprite mySprite;
    private final Gun myItem;
    private final List<Drawable> myDrawables;
    private float myCoolDown;
    private float myCurrAngleVar;

    public SolGun(Gun item, Vector2 relPos, boolean underShip) {
        this.myItem = item;
        if (this.myItem.config.lightOnShot) {
            Color lightCol = SolColor.WHITE;
            ProjectileConfig projConfig = this.myItem.config.clipConf.projConfig;
            if (projConfig.bodyEffect != null) {
                lightCol = projConfig.bodyEffect.tint;
            } else if (projConfig.collisionEffect != null) {
                lightCol = projConfig.collisionEffect.tint;
            }
            this.myLightSource = new LightSource(0.25f, true, 1.0f, Vector2.Zero, lightCol);
        } else {
            this.myLightSource = null;
        }
        this.myRelPos = new Vector2(relPos);
        DrawableLevel level = underShip ? DrawableLevel.U_GUNS : DrawableLevel.GUNS;
        float texLen = this.myItem.config.gunLength / this.myItem.config.texLenPercentage * 2.0f;
        this.mySprite = SpriteManager.createSprite(this.myItem.config.tex.name, texLen, 0.0f, 0.0f, new Vector2(relPos), level, 0.0f, 0.0f, SolColor.WHITE, false);
        this.myDrawables = new ArrayList<Drawable>();
        this.myDrawables.add(this.mySprite);
        if (this.myLightSource != null) {
            this.myLightSource.collectDrawables(this.myDrawables);
        }
    }

    public List<Drawable> getDrawables() {
        return this.myDrawables;
    }

    private void shoot(Vector2 gunVelocity, SolGame game, float gunAngle, Vector2 muzzlePos, Faction faction, SolObject creator, SolShip ship) {
        Vector2 baseVelocity = gunVelocity;
        Clip.Config cc = this.myItem.config.clipConf;
        if (cc.projConfig.zeroAbsSpeed) {
            baseVelocity = Vector2.Zero;
            Planet np = game.getPlanetManager().getNearestPlanet();
            if (np.isNearGround(muzzlePos)) {
                baseVelocity = new Vector2();
                np.calculateVelocityAtPosition(baseVelocity, muzzlePos);
            }
        }
        this.myCurrAngleVar = SolMath.approach(this.myCurrAngleVar, this.myItem.config.maxAngleVar, this.myItem.config.angleVarPerShot);
        boolean multiple = cc.projectilesPerShot > 1;
        for (int i = 0; i < cc.projectilesPerShot; ++i) {
            float bulletAngle = gunAngle;
            if (this.myCurrAngleVar > 0.0f) {
                bulletAngle += SolRandom.randomFloat(this.myCurrAngleVar);
            }
            Projectile proj = new Projectile(game, bulletAngle, muzzlePos, baseVelocity, faction, cc.projConfig, multiple, ship);
            game.getObjectManager().addObjDelayed(proj);
        }
        this.myCoolDown += this.myItem.config.timeBetweenShots;
        --this.myItem.ammo;
        game.getSoundManager().play(game, this.myItem.config.shootSound, muzzlePos, creator);
    }

    public void update(ItemContainer itemContainer, SolGame game, float gunAngle, SolObject creator, boolean shouldShoot, Faction faction, SolShip ship) {
        float gunRelAngle;
        float baseAngle = creator.getAngle();
        Vector2 basePos = creator.getPosition();
        this.mySprite.relativeAngle = gunRelAngle = gunAngle - baseAngle;
        Vector2 muzzleRelPos = SolMath.fromAl(gunRelAngle, this.myItem.config.gunLength);
        muzzleRelPos.add(this.myRelPos);
        if (this.myLightSource != null) {
            this.myLightSource.setRelativePosition(muzzleRelPos);
        }
        Vector2 muzzlePos = SolMath.toWorld(muzzleRelPos, baseAngle, basePos);
        SolMath.free(muzzleRelPos);
        float ts = game.getTimeStep();
        if (this.myItem.ammo <= 0 && this.myItem.reloadAwait <= 0.0f) {
            if (this.myItem.config.clipConf.infinite || itemContainer != null && itemContainer.tryConsumeItem(this.myItem.config.clipConf.example)) {
                this.myItem.reloadAwait = this.myItem.config.reloadTime + 1.0E-4f;
                game.getSoundManager().play(game, this.myItem.config.reloadSound, null, creator);
            }
        } else if (this.myItem.reloadAwait > 0.0f) {
            this.myItem.reloadAwait -= ts;
            if (this.myItem.reloadAwait <= 0.0f) {
                this.myItem.ammo = this.myItem.config.clipConf.size;
            }
        }
        if (this.myCoolDown > 0.0f) {
            this.myCoolDown -= ts;
        }
        boolean shot = shouldShoot && this.myCoolDown <= 0.0f && this.myItem.ammo > 0;
        game.getPartMan().updateAllHullEmittersOfType(ship, "shoot", shot);
        if (shot) {
            Vector2 gunVelocity = creator.getVelocity();
            this.shoot(gunVelocity, game, gunAngle, muzzlePos, faction, creator, ship);
        } else {
            this.myCurrAngleVar = SolMath.approach(this.myCurrAngleVar, this.myItem.config.minAngleVar, this.myItem.config.angleVarDamp * ts);
        }
        if (this.myLightSource != null) {
            this.myLightSource.update(shot, baseAngle, game);
        }
        SolMath.free(muzzlePos);
    }

    public Gun.Config getConfig() {
        return this.myItem.config;
    }

    public Gun getItem() {
        return this.myItem;
    }
}

