/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.input;

import org.destinationsol.common.SolRandom;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.ship.ShipAbility;
import org.destinationsol.game.ship.SolShip;

public class AbilityUpdater {
    private final float myAbilityUseStartPercentage = SolRandom.randomFloat(0.3f, 0.7f);
    private final int myChargesToKeep = SolRandom.randomInt(1, 2);
    private boolean myAbility;

    public void update(SolShip ship, SolShip nearestEnemy) {
        this.myAbility = false;
        if (nearestEnemy == null) {
            return;
        }
        ShipAbility ability = ship.getAbility();
        if (ability == null) {
            return;
        }
        if ((float)ship.getHull().config.getMaxLife() * this.myAbilityUseStartPercentage < ship.getLife()) {
            return;
        }
        SolItem ex = ability.getConfig().getChargeExample();
        if (ex != null && ship.getItemContainer().count(ex) <= this.myChargesToKeep) {
            return;
        }
        if (ability.getRadius() < nearestEnemy.getPosition().dst(ship.getPosition())) {
            return;
        }
        this.myAbility = true;
    }

    public boolean isAbility() {
        return this.myAbility;
    }
}

