/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.input;

import com.badlogic.gdx.math.Vector2;
import java.util.HashMap;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.Faction;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.input.AbilityUpdater;
import org.destinationsol.game.input.BattleDestProvider;
import org.destinationsol.game.input.BeaconDestProvider;
import org.destinationsol.game.input.MoveDestProvider;
import org.destinationsol.game.input.Mover;
import org.destinationsol.game.input.Pilot;
import org.destinationsol.game.input.Shooter;
import org.destinationsol.game.item.Engine;
import org.destinationsol.game.item.Gun;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.planet.PlanetBind;
import org.destinationsol.game.ship.FarShip;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.game.ship.hulls.HullConfig;

public class AiPilot
implements Pilot {
    public static final float MIN_IDLE_DIST = 0.8f;
    public static final float MAX_GROUND_BATTLE_SPD = 0.7f;
    public static final float MAX_BATTLE_SPD_BIG = 1.0f;
    public static final float MAX_BATTLE_SPD = 2.0f;
    public static final float MAX_BIND_AWAIT = 0.25f;
    public static final float MAX_RE_EQUIP_AWAIT = 3.0f;
    private final MoveDestProvider myDestProvider;
    private final boolean myCollectsItems;
    private final Mover myMover;
    private final Shooter myShooter;
    private Faction myFaction;
    private final boolean myShootAtObstacles;
    private final String myMapHint;
    private final BattleDestProvider myBattleDestProvider;
    private final float myDetectionDist;
    private final AbilityUpdater myAbilityUpdater;
    private float myBindAwait;
    private PlanetBind myPlanetBind;
    private float myReEquipAwait;

    public AiPilot(MoveDestProvider destProvider, boolean collectsItems, Faction faction, boolean shootAtObstacles, String mapHint, float detectionDist) {
        this.myDestProvider = destProvider;
        this.myDetectionDist = detectionDist;
        this.myMover = new Mover();
        this.myShooter = new Shooter();
        this.myBattleDestProvider = new BattleDestProvider();
        this.myCollectsItems = collectsItems;
        this.myFaction = faction;
        this.myShootAtObstacles = shootAtObstacles;
        this.myMapHint = mapHint;
        this.myAbilityUpdater = new AbilityUpdater();
    }

    @Override
    public void update(SolGame game, SolShip ship, SolShip nearestEnemy) {
        boolean hasEngine;
        boolean canShootUnfixed;
        this.myAbilityUpdater.update(ship, nearestEnemy);
        this.myPlanetBind = null;
        Vector2 shipPos = ship.getPosition();
        HullConfig hullConfig = ship.getHull().config;
        float maxIdleDist = this.getMaxIdleDist(hullConfig);
        this.myDestProvider.update(game, shipPos, maxIdleDist, hullConfig, nearestEnemy);
        Boolean canShoot = this.canShoot0(ship);
        boolean bl = canShootUnfixed = canShoot == null;
        if (canShootUnfixed) {
            canShoot = true;
        }
        Planet np = game.getPlanetManager().getNearestPlanet();
        boolean nearGround = np.isNearGround(shipPos);
        Vector2 dest = null;
        Vector2 destVelocity = null;
        boolean shouldStopNearDest = false;
        boolean avoidBigObjs = false;
        float desiredSpeed = this.myDestProvider.getDesiredSpeed();
        boolean bl2 = hasEngine = ship.getHull().getEngine() != null;
        if (hasEngine) {
            Boolean battle = null;
            if (nearestEnemy != null) {
                battle = this.myDestProvider.shouldManeuver(canShoot, nearestEnemy, nearGround);
            }
            if (battle != null) {
                float maxBattleSpeed;
                boolean big;
                dest = this.myBattleDestProvider.getDest(ship, nearestEnemy, np, battle, game.getTimeStep(), canShootUnfixed, nearGround);
                shouldStopNearDest = this.myBattleDestProvider.shouldStopNearDest();
                destVelocity = nearestEnemy.getVelocity();
                boolean bl3 = big = hullConfig.getType() == HullConfig.Type.BIG;
                float f = nearGround ? 0.7f : (maxBattleSpeed = big ? 1.0f : 2.0f);
                if (maxBattleSpeed < desiredSpeed) {
                    desiredSpeed = maxBattleSpeed;
                }
                if (!big) {
                    desiredSpeed += destVelocity.len();
                }
            } else {
                dest = this.myDestProvider.getDestination();
                destVelocity = this.myDestProvider.getDestinationVelocity();
                shouldStopNearDest = this.myDestProvider.shouldStopNearDestination();
                avoidBigObjs = this.myDestProvider.shouldAvoidBigObjects();
            }
        }
        this.myMover.update(game, ship, dest, np, maxIdleDist, hasEngine, avoidBigObjs, desiredSpeed, shouldStopNearDest, destVelocity);
        boolean moverActive = this.myMover.isActive();
        Vector2 enemyPos = nearestEnemy == null ? null : nearestEnemy.getPosition();
        Vector2 enemyVelocity = nearestEnemy == null ? null : nearestEnemy.getVelocity();
        float enemyApproxRad = nearestEnemy == null ? 0.0f : nearestEnemy.getHull().config.getApproxRadius();
        this.myShooter.update(ship, enemyPos, moverActive, canShoot, enemyVelocity, enemyApproxRad);
        if (hasEngine && !moverActive && !this.isShooterRotated()) {
            this.myMover.rotateOnIdle(ship, np, dest, shouldStopNearDest, maxIdleDist);
        }
        this.myReEquipAwait = this.myReEquipAwait <= 0.0f ? 3.0f : (this.myReEquipAwait -= game.getTimeStep());
    }

    private float getMaxIdleDist(HullConfig hullConfig) {
        float maxIdleDist = hullConfig.getApproxRadius();
        if (maxIdleDist < 0.8f) {
            maxIdleDist = 0.8f;
        }
        return maxIdleDist;
    }

    private Boolean canShoot0(SolShip ship) {
        Gun g1 = ship.getHull().getGun(false);
        if (g1 != null && g1.canShoot()) {
            return !g1.config.fixed ? null : Boolean.valueOf(true);
        }
        Gun g2 = ship.getHull().getGun(true);
        if (g2 != null && g2.canShoot()) {
            return !g2.config.fixed ? null : Boolean.valueOf(true);
        }
        return false;
    }

    private boolean isShooterRotated() {
        return this.myShooter.isLeft() || this.myShooter.isRight();
    }

    @Override
    public boolean isUp() {
        return this.myMover.isUp();
    }

    @Override
    public boolean isLeft() {
        return this.myMover.isLeft() || this.myShooter.isLeft();
    }

    @Override
    public boolean isRight() {
        return this.myMover.isRight() || this.myShooter.isRight();
    }

    @Override
    public boolean isShoot() {
        return this.myShooter.isShoot();
    }

    @Override
    public boolean isShoot2() {
        return this.myShooter.isShoot2();
    }

    @Override
    public boolean collectsItems() {
        return this.myCollectsItems;
    }

    @Override
    public boolean isAbility() {
        return this.myAbilityUpdater.isAbility();
    }

    @Override
    public Faction getFaction() {
        return this.myFaction;
    }

    @Override
    public void stringToFaction(String faction) {
        HashMap<String, Faction> factionMap = new HashMap<String, Faction>();
        if (faction.equals("laani")) {
            factionMap.put(faction, Faction.LAANI);
        }
        if (faction.equals("ehar")) {
            factionMap.put(faction, Faction.EHAR);
        }
        this.myFaction = (Faction)((Object)factionMap.get(faction));
    }

    @Override
    public boolean shootsAtObstacles() {
        return this.myShootAtObstacles;
    }

    @Override
    public float getDetectionDist() {
        return this.myDetectionDist;
    }

    @Override
    public String getMapHint() {
        return this.myMapHint;
    }

    @Override
    public void updateFar(SolGame game, FarShip farShip) {
        Vector2 shipPos = farShip.getPosition();
        HullConfig hullConfig = farShip.getHullConfig();
        float maxIdleDist = this.getMaxIdleDist(hullConfig);
        this.myDestProvider.update(game, shipPos, maxIdleDist, hullConfig, null);
        Vector2 dest = this.myDestProvider.getDestination();
        Vector2 velocity = farShip.getVelocity();
        float angle = farShip.getAngle();
        Engine engine = farShip.getEngine();
        float ts = game.getTimeStep();
        if (dest == null || engine == null) {
            if (this.myPlanetBind == null) {
                if (this.myBindAwait > 0.0f) {
                    this.myBindAwait -= ts;
                } else {
                    this.myPlanetBind = PlanetBind.tryBind(game, shipPos, angle);
                    this.myBindAwait = 0.25f;
                }
            }
            if (this.myPlanetBind != null) {
                this.myPlanetBind.setDiff(velocity, shipPos, false);
                velocity.scl(1.0f / ts);
                angle = this.myPlanetBind.getDesiredAngle();
            }
        } else {
            float desiredAngle;
            float toDestLen = shipPos.dst(dest);
            float maxIdleDistHack = 0.05f;
            if (this.myDestProvider.shouldStopNearDestination() && toDestLen < maxIdleDistHack) {
                velocity.set(this.myDestProvider.getDestinationVelocity());
                desiredAngle = angle;
            } else {
                desiredAngle = SolMath.angle(shipPos, dest);
                if (this.myDestProvider.shouldAvoidBigObjects()) {
                    desiredAngle = this.myMover.getBigObjAvoider().avoid(game, shipPos, dest, desiredAngle);
                }
                float desiredSpeed = this.myDestProvider.getDesiredSpeed();
                float speedDiff = engine.getAcceleration() * ts;
                float speed = SolMath.approach(velocity.len(), desiredSpeed, speedDiff);
                if (toDestLen < speed) {
                    speed = toDestLen;
                }
                SolMath.fromAl(velocity, desiredAngle, speed);
            }
            angle = SolMath.approachAngle(angle, desiredAngle, engine.getMaxRotationSpeed() * ts);
        }
        farShip.setVelocity(velocity);
        farShip.setAngle(angle);
        Vector2 newPos = SolMath.getVec(velocity);
        newPos.scl(ts);
        newPos.add(shipPos);
        farShip.setPos(newPos);
        SolMath.free(newPos);
    }

    @Override
    public String toDebugString() {
        return "moverActive: " + this.myMover.isActive();
    }

    @Override
    public boolean isPlayer() {
        return this.myDestProvider instanceof BeaconDestProvider;
    }
}

