/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.input;

import com.badlogic.gdx.math.Vector2;
import org.destinationsol.common.SolMath;
import org.destinationsol.common.SolRandom;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.ship.SolShip;

public class BattleDestProvider {
    public static final float MIN_DIR_CHANGE_AWAIT = 10.0f;
    public static final float MAX_DIR_CHANGE_AWAIT = 15.0f;
    private final Vector2 myDest = new Vector2();
    private boolean myStopNearDest;
    private Boolean myCw = SolRandom.test(0.5f);
    private float myDirChangeAwait;

    public Vector2 getDest(SolShip ship, SolShip enemy, Planet np, boolean battle, float ts, boolean canShootUnfixed, boolean nearGround) {
        this.myDirChangeAwait -= ts;
        if (this.myDirChangeAwait <= 0.0f) {
            int rnd = SolRandom.randomInt(0, 2);
            this.myCw = rnd == 0 ? null : Boolean.valueOf(rnd == 1);
            this.myDirChangeAwait = SolRandom.randomFloat(10.0f, 15.0f);
        }
        if (!battle) {
            throw new AssertionError((Object)"can't flee yet!");
        }
        Vector2 enemyPos = enemy.getPosition();
        float approxRad = ship.getHull().config.getApproxRadius();
        float enemyApproxRad = enemy.getHull().config.getApproxRadius();
        if (nearGround) {
            float prefAngle = SolMath.angle(np.getPosition(), enemyPos);
            this.myStopNearDest = false;
            float dist = canShootUnfixed ? 1.008f : 2.1f;
            SolMath.fromAl(this.myDest, prefAngle, dist += approxRad + enemyApproxRad);
            this.myDest.add(enemyPos);
        } else {
            Vector2 shipPos = ship.getPosition();
            float a = SolMath.angle(enemyPos, shipPos);
            if (this.myCw != null) {
                a += (float)(90 * SolMath.toInt(this.myCw));
            }
            float len = canShootUnfixed ? 3.24f : 2.25f;
            SolMath.fromAl(this.myDest, a, len += approxRad + enemyApproxRad);
            this.myDest.add(enemyPos);
            this.myStopNearDest = false;
        }
        return this.myDest;
    }

    public boolean shouldStopNearDest() {
        return this.myStopNearDest;
    }
}

