/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.input;

import com.badlogic.gdx.math.Vector2;
import org.destinationsol.game.BeaconHandler;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.input.MoveDestProvider;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.game.ship.hulls.HullConfig;

public class BeaconDestProvider
implements MoveDestProvider {
    public static final float STOP_AWAIT = 0.1f;
    private final Vector2 myDest = new Vector2();
    private Boolean myShouldManeuver;
    private boolean myShouldStopNearDest;
    private Vector2 myDestVelocity = new Vector2();

    @Override
    public void update(SolGame game, Vector2 shipPos, float maxIdleDist, HullConfig hullConfig, SolShip nearestEnemy) {
        BeaconHandler bh = game.getBeaconHandler();
        this.myDest.set(bh.getPos());
        this.myShouldManeuver = null;
        BeaconHandler.Action a = bh.getCurrAction();
        if (nearestEnemy != null && a == BeaconHandler.Action.ATTACK && shipPos.dst(this.myDest) < shipPos.dst(nearestEnemy.getPosition()) + 0.1f) {
            this.myShouldManeuver = true;
        }
        this.myShouldStopNearDest = 0.1f < game.getTime() - bh.getClickTime();
        this.myDestVelocity.set(bh.getVelocity());
    }

    @Override
    public Vector2 getDestination() {
        return this.myDest;
    }

    @Override
    public Boolean shouldManeuver(boolean canShoot, SolShip nearestEnemy, boolean nearGround) {
        return this.myShouldManeuver;
    }

    @Override
    public Vector2 getDestinationVelocity() {
        return this.myDestVelocity;
    }

    @Override
    public boolean shouldAvoidBigObjects() {
        return true;
    }

    @Override
    public float getDesiredSpeed() {
        return 8.0f;
    }

    @Override
    public boolean shouldStopNearDestination() {
        return this.myShouldStopNearDest;
    }
}

