/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.input;

import com.badlogic.gdx.math.Vector2;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.planet.Planet;

public class BigObjAvoider {
    private static final float MAX_DIST_LEN = 78.0f;
    private Vector2 myProj = new Vector2();

    BigObjAvoider() {
    }

    public float avoid(SolGame game, Vector2 from, Vector2 destination, float angleToDestination) {
        float distanceToDestination = from.dst(destination);
        if (distanceToDestination > 78.0f) {
            distanceToDestination = 78.0f;
        }
        float result = angleToDestination;
        Planet planet = game.getPlanetManager().getNearestPlanet(from);
        Vector2 planetPosition = planet.getPosition();
        float planetRadius = planet.getFullHeight();
        if (destination.dst(planetPosition) < planetRadius) {
            planetRadius = planet.getGroundHeight();
        }
        this.myProj.set(planetPosition);
        this.myProj.sub(from);
        SolMath.rotate(this.myProj, -angleToDestination);
        if (0.0f < this.myProj.x && this.myProj.x < distanceToDestination && SolMath.abs(this.myProj.y) < planetRadius) {
            distanceToDestination = this.myProj.x;
            result = angleToDestination + (float)(45 * SolMath.toInt(this.myProj.y < 0.0f));
        }
        Vector2 sunPos = planet.getSystem().getPosition();
        float sunRad = 78.0f;
        this.myProj.set(sunPos);
        this.myProj.sub(from);
        SolMath.rotate(this.myProj, -angleToDestination);
        if (0.0f < this.myProj.x && this.myProj.x < distanceToDestination && SolMath.abs(this.myProj.y) < sunRad) {
            result = angleToDestination + (float)(45 * SolMath.toInt(this.myProj.y < 0.0f));
        }
        return result;
    }
}

