/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.input;

import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.common.SolMath;
import org.destinationsol.common.SolRandom;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.input.MoveDestProvider;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.planet.SolSystem;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.game.ship.hulls.HullConfig;

public class ExplorerDestProvider
implements MoveDestProvider {
    public static final int MAX_AWAIT_ON_PLANET = 30;
    public static final int LAST_PLANETS_TO_AVOID = 2;
    private final Vector2 destination;
    private final boolean isAggressive;
    private final float desiredSpeed;
    private final SolSystem system;
    private Vector2 relativeDestination;
    private Planet planet;
    private float awaitOnPlanet;
    private boolean landInDestination;
    private Vector2 destinationVelocity;

    public ExplorerDestProvider(Vector2 position, boolean aggressive, HullConfig config, SolSystem system) {
        this.system = system;
        this.destination = new Vector2();
        float minDistance = Float.MAX_VALUE;
        ArrayList<Planet> planets = this.system.getPlanets();
        int sz = this.allowedSize();
        for (int i = 0; i < sz; ++i) {
            Planet planet = planets.get(i);
            float distance = planet.getPosition().dst(position);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            this.planet = planet;
        }
        this.calculateRelativeDestination(config);
        this.awaitOnPlanet = 30.0f;
        this.isAggressive = aggressive;
        this.desiredSpeed = config.getType() == HullConfig.Type.BIG ? 2.0f : 4.0f;
        this.destinationVelocity = new Vector2();
    }

    private int allowedSize() {
        int size = this.system.getPlanets().size();
        if (!this.system.getConfig().hard) {
            size -= 2;
        }
        return size;
    }

    private void calculateRelativeDestination(HullConfig hullConfig) {
        List<Vector2> landingPlaces = this.planet.getLandingPlaces();
        if (landingPlaces.size() > 0) {
            this.relativeDestination = new Vector2(SolRandom.randomElement(landingPlaces));
            float distance = this.relativeDestination.len();
            float aboveGround = hullConfig.getType() == HullConfig.Type.BIG ? 10.5f : 0.75f * hullConfig.getSize();
            this.relativeDestination.scl((distance + aboveGround) / distance);
            this.landInDestination = true;
        } else {
            this.relativeDestination = new Vector2();
            SolMath.fromAl(this.relativeDestination, SolRandom.randomFloat(180.0f), this.planet.getGroundHeight() + 4.2000003f);
            this.landInDestination = false;
        }
    }

    @Override
    public Vector2 getDestination() {
        return this.destination;
    }

    @Override
    public boolean shouldStopNearDestination() {
        return true;
    }

    @Override
    public void update(SolGame game, Vector2 shipPos, float maxIdleDist, HullConfig hullConfig, SolShip nearestEnemy) {
        if (this.destination.dst(shipPos) < maxIdleDist) {
            if (this.awaitOnPlanet > 0.0f) {
                this.awaitOnPlanet -= game.getTimeStep();
            } else {
                ArrayList<Planet> planets = this.system.getPlanets();
                int planetIndex = SolRandom.randomInt(this.allowedSize());
                this.planet = planets.get(planetIndex);
                this.calculateRelativeDestination(hullConfig);
                this.awaitOnPlanet = 30.0f;
            }
        }
        if (!this.landInDestination && !this.planet.getLandingPlaces().isEmpty()) {
            this.calculateRelativeDestination(hullConfig);
        }
        SolMath.toWorld(this.destination, this.relativeDestination, this.planet.getAngle(), this.planet.getPosition());
        this.planet.calculateVelocityAtPosition(this.destinationVelocity, this.destination);
    }

    @Override
    public Boolean shouldManeuver(boolean canShoot, SolShip nearestEnemy, boolean nearGround) {
        if (this.isAggressive && canShoot) {
            return true;
        }
        return null;
    }

    @Override
    public Vector2 getDestinationVelocity() {
        return this.destinationVelocity;
    }

    @Override
    public boolean shouldAvoidBigObjects() {
        return true;
    }

    @Override
    public float getDesiredSpeed() {
        return this.desiredSpeed;
    }
}

