/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.input;

import com.badlogic.gdx.math.Vector2;
import java.util.List;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.ObjectManager;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.input.MoveDestProvider;
import org.destinationsol.game.input.Pilot;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.ship.FarShip;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.game.ship.hulls.HullConfig;

public class Guardian
implements MoveDestProvider {
    public static final float DIST = 1.5f;
    private final Pilot myTargetPilot;
    private final Vector2 myDest;
    private final float myRelAngle;
    private SolShip myTarget;
    private FarShip myFarTarget;

    public Guardian(SolGame game, HullConfig hullConfig, Pilot targetPilot, Vector2 targetPos, HullConfig targetHc, float relAngle) {
        this.myTargetPilot = targetPilot;
        this.myDest = new Vector2();
        this.myRelAngle = relAngle;
        this.setDest(game, targetPos, targetHc.getApproxRadius(), hullConfig);
    }

    @Override
    public Vector2 getDestination() {
        return this.myDest;
    }

    @Override
    public boolean shouldAvoidBigObjects() {
        return false;
    }

    @Override
    public float getDesiredSpeed() {
        return 8.0f;
    }

    @Override
    public boolean shouldStopNearDestination() {
        return true;
    }

    @Override
    public void update(SolGame game, Vector2 shipPos, float maxIdleDist, HullConfig hullConfig, SolShip nearestEnemy) {
        float targetApproxRad;
        Vector2 targetPos;
        this.updateTarget(game);
        this.myDest.set(shipPos);
        if (this.myTarget == null) {
            if (this.myFarTarget == null) {
                return;
            }
            targetPos = this.myFarTarget.getPosition();
            targetApproxRad = this.myFarTarget.getHullConfig().getApproxRadius();
        } else {
            targetPos = this.myTarget.getPosition();
            targetApproxRad = this.myTarget.getHull().config.getApproxRadius();
        }
        this.setDest(game, targetPos, targetApproxRad, hullConfig);
    }

    public void updateTarget(SolGame game) {
        ObjectManager om = game.getObjectManager();
        List<SolObject> objs = om.getObjects();
        if (this.myTarget != null && objs.contains(this.myTarget)) {
            return;
        }
        this.myTarget = null;
        List<FarShip> farShips = om.getFarShips();
        if (this.myFarTarget != null && farShips.contains(this.myFarTarget)) {
            return;
        }
        this.myFarTarget = null;
        for (SolObject o : objs) {
            SolShip other;
            if (!(o instanceof SolShip) || (other = (SolShip)o).getPilot() != this.myTargetPilot) continue;
            this.myTarget = other;
            return;
        }
        for (FarShip other : farShips) {
            if (other.getPilot() != this.myTargetPilot) continue;
            this.myFarTarget = other;
            return;
        }
    }

    private void setDest(SolGame game, Vector2 targetPos, float targetApproxRad, HullConfig hullConfig) {
        Planet np = game.getPlanetManager().getNearestPlanet(targetPos);
        float desiredAngle = this.myRelAngle;
        if (np.isNearGround(targetPos)) {
            desiredAngle = SolMath.angle(np.getPosition(), targetPos);
        }
        SolMath.fromAl(this.myDest, desiredAngle, targetApproxRad + 1.5f + hullConfig.getApproxRadius());
        this.myDest.add(targetPos);
    }

    @Override
    public Boolean shouldManeuver(boolean canShoot, SolShip nearestEnemy, boolean nearGround) {
        if (!canShoot) {
            return null;
        }
        Vector2 targetPos = null;
        if (this.myTarget != null) {
            targetPos = this.myTarget.getPosition();
        } else if (this.myFarTarget != null) {
            targetPos = this.myFarTarget.getPosition();
        }
        float maxManeuverDist = 2.0f * (nearGround ? 2.8f : 4.5f);
        if (targetPos != null && maxManeuverDist < targetPos.dst(nearestEnemy.getPosition())) {
            return null;
        }
        return true;
    }

    @Override
    public Vector2 getDestinationVelocity() {
        return this.myTarget == null ? Vector2.Zero : this.myTarget.getVelocity();
    }

    public float getRelAngle() {
        return this.myRelAngle;
    }
}

