/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.input;

import com.badlogic.gdx.math.Vector2;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.input.BigObjAvoider;
import org.destinationsol.game.input.SmallObjAvoider;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.ship.SolShip;

public class Mover {
    private static final float MIN_MOVE_AAD = 2.0f;
    private static final float MIN_ANGLE_TO_ACC = 5.0f;
    private static final float MIN_PLANET_MOVE_AAD = 2.0f;
    private static final float MAX_ABS_SPD_DEV = 0.1f;
    private static final float MAX_REL_SPD_DEV = 0.05f;
    private final BigObjAvoider myBigObjAvoider = new BigObjAvoider();
    private final SmallObjAvoider mySmallObjAvoider = new SmallObjAvoider();
    private boolean myUp;
    private boolean myLeft;
    private boolean myRight;
    private Vector2 myDesiredVelocity = new Vector2();

    Mover() {
    }

    public static Boolean needsToTurn(float angle, float destAngle, float rotationSpeed, float rotAcc, float allowedAngleDiff) {
        float relAngleAfterBreak;
        if (SolMath.angleDiff(destAngle, angle) < allowedAngleDiff || rotAcc == 0.0f) {
            return null;
        }
        float breakWay = rotationSpeed * rotationSpeed / rotAcc / 2.0f;
        float angleAfterBreak = angle + breakWay * (float)SolMath.toInt(rotationSpeed > 0.0f);
        float relAngle = SolMath.norm(angle - destAngle);
        if (relAngle > 0.0f == (relAngleAfterBreak = SolMath.norm(angleAfterBreak - destAngle)) > 0.0f) {
            return relAngle < 0.0f;
        }
        return relAngle > 0.0f;
    }

    public void update(SolGame game, SolShip ship, Vector2 dest, Planet np, float maxIdleDist, boolean hasEngine, boolean avoidBigObjs, float desiredSpeed, boolean stopNearDest, Vector2 destVelocity) {
        this.myUp = false;
        this.myLeft = false;
        this.myRight = false;
        if (!hasEngine || dest == null) {
            return;
        }
        Vector2 shipPos = ship.getPosition();
        float toDestLen = shipPos.dst(dest);
        if (toDestLen < maxIdleDist) {
            if (!stopNearDest) {
                return;
            }
            this.myDesiredVelocity.set(destVelocity);
        } else {
            this.updateDesiredVelocity(game, ship, dest, toDestLen, stopNearDest, np, avoidBigObjs, desiredSpeed, destVelocity);
        }
        Vector2 shipVelocity = ship.getVelocity();
        float speedDeviation = shipVelocity.dst(this.myDesiredVelocity);
        if (speedDeviation < 0.1f || speedDeviation < 0.05f * shipVelocity.len()) {
            return;
        }
        float shipAngle = ship.getAngle();
        float rotationSpeed = ship.getRotationSpeed();
        float rotAcc = ship.getRotationAcceleration();
        float desiredAngle = SolMath.angle(shipVelocity, this.myDesiredVelocity);
        float angleDiff = SolMath.angleDiff(desiredAngle, shipAngle);
        this.myUp = angleDiff < 5.0f;
        Boolean ntt = Mover.needsToTurn(shipAngle, desiredAngle, rotationSpeed, rotAcc, 2.0f);
        if (ntt != null) {
            if (ntt.booleanValue()) {
                this.myRight = true;
            } else {
                this.myLeft = true;
            }
        }
    }

    private void updateDesiredVelocity(SolGame game, SolShip ship, Vector2 dest, float toDestLen, boolean stopNearDest, Planet np, boolean avoidBigObjs, float desiredSpeed, Vector2 destVelocity) {
        float toDestAngle = this.getToDestAngle(game, ship, dest, avoidBigObjs, np);
        if (stopNearDest) {
            float breakWay;
            float turnWay;
            boolean needsToBreak;
            float tangentSpeed = SolMath.project(ship.getVelocity(), toDestAngle);
            boolean bl = needsToBreak = toDestLen < 0.5f * tangentSpeed + (turnWay = tangentSpeed * ship.calcTimeToTurn(toDestAngle + 180.0f)) + (breakWay = tangentSpeed * tangentSpeed / ship.getAcceleration() / 2.0f);
            if (needsToBreak) {
                this.myDesiredVelocity.set(destVelocity);
                return;
            }
        }
        SolMath.fromAl(this.myDesiredVelocity, toDestAngle, desiredSpeed);
    }

    public void rotateOnIdle(SolShip ship, Planet np, Vector2 dest, boolean stopNearDest, float maxIdleDist) {
        float allowedAngleDiff;
        float desiredAngle;
        if (this.isActive() || dest == null) {
            return;
        }
        Vector2 shipPos = ship.getPosition();
        float shipAngle = ship.getAngle();
        float toDestLen = shipPos.dst(dest);
        boolean nearFinalDest = stopNearDest && toDestLen < maxIdleDist;
        float dstToPlanet = np.getPosition().dst(shipPos);
        if (nearFinalDest) {
            if (np.getFullHeight() < dstToPlanet) {
                return;
            }
            desiredAngle = SolMath.angle(np.getPosition(), shipPos);
            allowedAngleDiff = 2.0f;
        } else {
            if (dstToPlanet < np.getFullHeight() + 14.0f) {
                return;
            }
            desiredAngle = SolMath.angle(ship.getVelocity());
            allowedAngleDiff = 2.0f;
        }
        Boolean ntt = Mover.needsToTurn(shipAngle, desiredAngle, ship.getRotationSpeed(), ship.getRotationAcceleration(), allowedAngleDiff);
        if (ntt != null) {
            if (ntt.booleanValue()) {
                this.myRight = true;
            } else {
                this.myLeft = true;
            }
        }
    }

    private float getToDestAngle(SolGame game, SolShip ship, Vector2 dest, boolean avoidBigObjs, Planet np) {
        Vector2 shipPos = ship.getPosition();
        float toDestAngle = SolMath.angle(shipPos, dest);
        if (avoidBigObjs) {
            toDestAngle = this.myBigObjAvoider.avoid(game, shipPos, dest, toDestAngle);
        }
        toDestAngle = this.mySmallObjAvoider.avoid(game, ship, toDestAngle, np);
        return toDestAngle;
    }

    public boolean isUp() {
        return this.myUp;
    }

    public boolean isLeft() {
        return this.myLeft;
    }

    public boolean isRight() {
        return this.myRight;
    }

    public boolean isActive() {
        return this.myUp || this.myLeft || this.myRight;
    }

    public BigObjAvoider getBigObjAvoider() {
        return this.myBigObjAvoider;
    }
}

