/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.input;

import com.badlogic.gdx.math.Vector2;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.input.MoveDestProvider;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.game.ship.hulls.HullConfig;

public class OrbiterDestProvider
implements MoveDestProvider {
    private final Planet myPlanet;
    private final float myDesiredSpeed;
    private final float myHeight;
    private final boolean myCw;
    private final Vector2 myDest;

    public OrbiterDestProvider(Planet planet, float height, boolean cw) {
        this.myPlanet = planet;
        this.myHeight = height;
        this.myCw = cw;
        this.myDesiredSpeed = SolMath.sqrt(this.myPlanet.getGravitationConstant() / this.myHeight);
        this.myDest = new Vector2();
    }

    @Override
    public Vector2 getDestination() {
        return this.myDest;
    }

    @Override
    public boolean shouldAvoidBigObjects() {
        return false;
    }

    @Override
    public float getDesiredSpeed() {
        return this.myDesiredSpeed;
    }

    @Override
    public boolean shouldStopNearDestination() {
        return false;
    }

    @Override
    public void update(SolGame game, Vector2 shipPos, float maxIdleDist, HullConfig hullConfig, SolShip nearestEnemy) {
        Vector2 pPos = this.myPlanet.getPosition();
        float destAngle = SolMath.angle(pPos, shipPos) + (float)(5 * SolMath.toInt(this.myCw));
        SolMath.fromAl(this.myDest, destAngle, this.myHeight);
        this.myDest.add(pPos);
    }

    @Override
    public Boolean shouldManeuver(boolean canShoot, SolShip nearestEnemy, boolean nearGround) {
        return null;
    }

    @Override
    public Vector2 getDestinationVelocity() {
        return Vector2.Zero;
    }
}

