/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.input;

import com.badlogic.gdx.math.Vector2;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.gun.GunMount;
import org.destinationsol.game.input.Mover;
import org.destinationsol.game.item.Gun;
import org.destinationsol.game.projectile.ProjectileConfig;
import org.destinationsol.game.ship.SolShip;

public class Shooter {
    private static final float ENEMY_SPEED_FACTOR = 0.6f;
    public static final float MIN_SHOOT_AAD = 2.0f;
    private boolean myShoot;
    private boolean myShoot2;
    private boolean myRight;
    private boolean myLeft;

    Shooter() {
    }

    public static float calcShootAngle(Vector2 gunPos, Vector2 gunVelocity, Vector2 enemyPos, Vector2 enemyVelocity, float projSpeed, boolean sharp) {
        float shootAngle;
        Vector2 enemyVelocityShortened = SolMath.getVec(enemyVelocity);
        if (!sharp) {
            enemyVelocityShortened.scl(0.6f);
        }
        Vector2 relativeEnemyVelocity = SolMath.distVec(gunVelocity, enemyVelocityShortened);
        SolMath.free(enemyVelocityShortened);
        float rotAngle = SolMath.angle(relativeEnemyVelocity);
        float relativeEnemySpeed = relativeEnemyVelocity.len();
        SolMath.free(relativeEnemyVelocity);
        Vector2 distToEnemy = SolMath.distVec(gunPos, enemyPos);
        SolMath.rotate(distToEnemy, -rotAngle);
        float x = distToEnemy.x;
        float y = distToEnemy.y;
        float a = relativeEnemySpeed * relativeEnemySpeed - projSpeed * projSpeed;
        float b = 2.0f * x * relativeEnemySpeed;
        float c = x * x + y * y;
        float t = SolMath.genQuad(a, b, c);
        if (t != t) {
            shootAngle = Float.NaN;
        } else {
            distToEnemy.x += t * relativeEnemySpeed;
            shootAngle = SolMath.angle(distToEnemy) + rotAngle;
        }
        SolMath.free(distToEnemy);
        return shootAngle;
    }

    public void update(SolShip ship, Vector2 enemyPos, boolean notRotate, boolean canShoot, Vector2 enemyVelocity, float enemyApproxRad) {
        ProjectileConfig projConfig;
        this.myLeft = false;
        this.myRight = false;
        this.myShoot = false;
        this.myShoot2 = false;
        Vector2 shipPos = ship.getPosition();
        if (enemyPos == null || !canShoot) {
            return;
        }
        float toEnemyDst = enemyPos.dst(shipPos);
        Gun gun1 = this.processGun(ship, false);
        Gun gun2 = this.processGun(ship, true);
        if (gun1 == null && gun2 == null) {
            return;
        }
        float projSpeed = 0.0f;
        Gun gun = null;
        if (gun1 != null) {
            projConfig = gun1.config.clipConf.projConfig;
            projSpeed = projConfig.speed + projConfig.acc;
            gun = gun1;
        }
        if (gun2 != null) {
            projConfig = gun2.config.clipConf.projConfig;
            float g2PS = projConfig.speed + projConfig.acc;
            if (projSpeed < g2PS) {
                projSpeed = g2PS;
                gun = gun2;
            }
        }
        Vector2 gunRelPos = ship.getHull().getGunMount(gun == gun2).getRelPos();
        Vector2 gunPos = SolMath.toWorld(gunRelPos, ship.getAngle(), shipPos);
        float shootAngle = Shooter.calcShootAngle(gunPos, ship.getVelocity(), enemyPos, enemyVelocity, projSpeed, false);
        SolMath.free(gunPos);
        if (shootAngle != shootAngle) {
            return;
        }
        float toShip = SolMath.angle(enemyPos, shipPos);
        float toGun = SolMath.angle(enemyPos, gunPos);
        shootAngle += toGun - toShip;
        float shipAngle = ship.getAngle();
        float maxAngleDiff = SolMath.angularWidthOfSphere(enemyApproxRad, toEnemyDst) + 10.0f;
        ProjectileConfig projConfig2 = gun.config.clipConf.projConfig;
        if (projSpeed > 0.0f && projConfig2.guideRotationSpeed > 0.0f) {
            maxAngleDiff += projConfig2.guideRotationSpeed * toEnemyDst / projSpeed;
        }
        if (SolMath.angleDiff(shootAngle, shipAngle) < maxAngleDiff) {
            this.myShoot = true;
            this.myShoot2 = true;
            return;
        }
        if (notRotate) {
            return;
        }
        Boolean needsToTurn = Mover.needsToTurn(shipAngle, shootAngle, ship.getRotationSpeed(), ship.getRotationAcceleration(), 2.0f);
        if (needsToTurn != null) {
            if (needsToTurn.booleanValue()) {
                this.myRight = true;
            } else {
                this.myLeft = true;
            }
        }
    }

    private Gun processGun(SolShip ship, boolean second) {
        GunMount mount = ship.getHull().getGunMount(second);
        if (mount == null) {
            return null;
        }
        Gun g = mount.getGun();
        if (g == null || g.ammo <= 0) {
            return null;
        }
        if (g.config.clipConf.projConfig.zeroAbsSpeed || g.config.clipConf.projConfig.guideRotationSpeed > 0.0f) {
            if (second) {
                this.myShoot2 = true;
            } else {
                this.myShoot = true;
            }
            return null;
        }
        if (g.config.fixed) {
            return g;
        }
        if (mount.isDetected()) {
            if (second) {
                this.myShoot2 = true;
            } else {
                this.myShoot = true;
            }
        }
        return null;
    }

    public boolean isShoot() {
        return this.myShoot;
    }

    public boolean isShoot2() {
        return this.myShoot2;
    }

    public boolean isLeft() {
        return this.myLeft;
    }

    public boolean isRight() {
        return this.myRight;
    }
}

