/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.input;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.RayCastCallback;
import com.badlogic.gdx.physics.box2d.World;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.ship.SolShip;

public class SmallObjAvoider {
    public static final float MANEUVER_TIME = 2.0f;
    public static final float MIN_RAYCAST_LEN = 0.5f;
    private final RayCastCallback myRayBack = new MyRayBack();
    private final Vector2 myDest = new Vector2();
    private SolShip myShip;
    private boolean myCollided;

    public float avoid(SolGame game, SolShip ship, float toDestAngle, Planet np) {
        float ttt;
        this.myShip = ship;
        Vector2 shipPos = ship.getPosition();
        float shipSpeed = ship.getVelocity().len();
        float raycastLen = shipSpeed * ((ttt = ship.calcTimeToTurn(toDestAngle + 45.0f)) + 2.0f);
        if (raycastLen < 0.5f) {
            raycastLen = 0.5f;
        }
        SolMath.fromAl(this.myDest, toDestAngle, raycastLen);
        this.myDest.add(shipPos);
        this.myCollided = false;
        World w = game.getObjectManager().getWorld();
        w.rayCast(this.myRayBack, shipPos, this.myDest);
        if (!this.myCollided) {
            return toDestAngle;
        }
        SolMath.fromAl(this.myDest, toDestAngle += 45.0f, raycastLen);
        this.myDest.add(shipPos);
        this.myCollided = false;
        w.rayCast(this.myRayBack, shipPos, this.myDest);
        if (!this.myCollided) {
            return toDestAngle;
        }
        SolMath.fromAl(this.myDest, toDestAngle -= 90.0f, raycastLen);
        this.myDest.add(shipPos);
        this.myCollided = false;
        w.rayCast(this.myRayBack, shipPos, this.myDest);
        if (!this.myCollided) {
            return toDestAngle;
        }
        if (np.getFullHeight() < np.getPosition().dst(shipPos)) {
            return toDestAngle - 45.0f;
        }
        return SolMath.angle(np.getPosition(), shipPos);
    }

    private class MyRayBack
    implements RayCastCallback {
        private MyRayBack() {
        }

        public float reportRayFixture(Fixture fixture, Vector2 point, Vector2 normal, float fraction) {
            SolObject o = (SolObject)fixture.getBody().getUserData();
            if (SmallObjAvoider.this.myShip == o) {
                return -1.0f;
            }
            SmallObjAvoider.this.myCollided = true;
            return 0.0f;
        }
    }
}

