/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.input;

import com.badlogic.gdx.math.Vector2;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.ShipConfig;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.input.MoveDestProvider;
import org.destinationsol.game.planet.PlanetBind;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.game.ship.hulls.HullConfig;

public class StillGuard
implements MoveDestProvider {
    private final PlanetBind myPlanetBind;
    private final float myDesiredSpeed;
    private Vector2 myDest;
    private Vector2 myDestVelocity;

    public StillGuard(Vector2 target, SolGame game, ShipConfig sc) {
        this.myDest = new Vector2(target);
        this.myPlanetBind = PlanetBind.tryBind(game, this.myDest, 0.0f);
        this.myDesiredSpeed = sc.hull.getType() == HullConfig.Type.BIG ? 2.0f : 4.0f;
        this.myDestVelocity = new Vector2();
    }

    @Override
    public Vector2 getDestination() {
        return this.myDest;
    }

    @Override
    public boolean shouldAvoidBigObjects() {
        return this.myPlanetBind != null;
    }

    @Override
    public float getDesiredSpeed() {
        return this.myDesiredSpeed;
    }

    @Override
    public boolean shouldStopNearDestination() {
        return true;
    }

    @Override
    public void update(SolGame game, Vector2 shipPos, float maxIdleDist, HullConfig hullConfig, SolShip nearestEnemy) {
        if (this.myPlanetBind != null) {
            Vector2 diff = SolMath.getVec();
            this.myPlanetBind.setDiff(diff, this.myDest, false);
            this.myDest.add(diff);
            SolMath.free(diff);
            this.myPlanetBind.getPlanet().calculateVelocityAtPosition(this.myDestVelocity, this.myDest);
        }
    }

    @Override
    public Boolean shouldManeuver(boolean canShoot, SolShip nearestEnemy, boolean nearGround) {
        return true;
    }

    @Override
    public Vector2 getDestinationVelocity() {
        return this.myDestVelocity;
    }
}

