/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.item;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import org.destinationsol.assets.Assets;
import org.destinationsol.assets.json.Validator;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.item.ItemManager;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.item.SolItemType;
import org.destinationsol.game.item.SolItemTypes;
import org.json.JSONObject;

public class AbilityCharge
implements SolItem {
    private final Config config;

    AbilityCharge(Config config) {
        this.config = config;
    }

    @Override
    public String getDisplayName() {
        return this.config.displayName;
    }

    @Override
    public float getPrice() {
        return this.config.price;
    }

    @Override
    public String getDescription() {
        return this.config.description;
    }

    @Override
    public SolItem copy() {
        return new AbilityCharge(this.config);
    }

    @Override
    public boolean isSame(SolItem item) {
        return item instanceof AbilityCharge && ((AbilityCharge)item).config == this.config;
    }

    @Override
    public TextureAtlas.AtlasRegion getIcon(SolGame game) {
        return this.config.icon;
    }

    @Override
    public SolItemType getItemType() {
        return this.config.itemType;
    }

    @Override
    public String getCode() {
        return this.config.code;
    }

    @Override
    public int isEquipped() {
        return 0;
    }

    @Override
    public void setEquipped(int equipped) {
    }

    public static class Config {
        public final SolItemType itemType;
        public final String code;
        public final TextureAtlas.AtlasRegion icon;
        public final float price;
        public final String displayName;
        public final String description;
        public final AbilityCharge example;

        public Config(TextureAtlas.AtlasRegion icon, float price, String displayName, String description, SolItemType itemType, String code) {
            this.icon = icon;
            this.price = price;
            this.displayName = displayName;
            this.description = description;
            this.itemType = itemType;
            this.code = code;
            this.example = new AbilityCharge(this);
        }

        public static void load(String abilityName, ItemManager itemManager, SolItemTypes types) {
            JSONObject rootNode = Validator.getValidatedJSON(abilityName, "engine:schemaAbilityCharges");
            float price = (float)rootNode.getDouble("price");
            String displayName = rootNode.getString("displayName");
            String desc = rootNode.getString("desc");
            TextureAtlas.AtlasRegion icon = Assets.getAtlasRegion(abilityName + "Icon");
            Config abilityConfig = new Config(icon, price, displayName, desc, types.abilityCharge, abilityName);
            itemManager.registerItem(abilityConfig.example);
        }
    }
}

