/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.item;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import java.util.ArrayList;
import org.destinationsol.assets.Assets;
import org.destinationsol.assets.json.Validator;
import org.destinationsol.assets.sound.OggSoundManager;
import org.destinationsol.assets.sound.OggSoundSet;
import org.destinationsol.assets.sound.PlayableSound;
import org.destinationsol.game.DmgType;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.item.ItemManager;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.item.SolItemType;
import org.destinationsol.game.item.SolItemTypes;
import org.json.JSONObject;

public class Armor
implements SolItem {
    private final Config config;
    private int myEquipped;

    private Armor(Config config) {
        this.config = config;
    }

    private Armor(Config config, int equipped) {
        this(config);
        this.myEquipped = equipped;
    }

    @Override
    public String getDisplayName() {
        return this.config.displayName;
    }

    @Override
    public float getPrice() {
        return this.config.price;
    }

    @Override
    public String getDescription() {
        return this.config.desc;
    }

    @Override
    public SolItem copy() {
        return new Armor(this.config, this.myEquipped);
    }

    @Override
    public boolean isSame(SolItem item) {
        return false;
    }

    @Override
    public TextureAtlas.AtlasRegion getIcon(SolGame game) {
        return this.config.icon;
    }

    @Override
    public SolItemType getItemType() {
        return this.config.itemType;
    }

    @Override
    public String getCode() {
        return this.config.code;
    }

    public float getPerc() {
        return this.config.perc;
    }

    public PlayableSound getHitSound(DmgType dmgType) {
        switch (dmgType) {
            case BULLET: {
                return this.config.bulletHitSound;
            }
            case ENERGY: {
                return this.config.energyHitSound;
            }
        }
        return null;
    }

    @Override
    public int isEquipped() {
        return this.myEquipped;
    }

    @Override
    public void setEquipped(int equipped) {
        this.myEquipped = equipped;
    }

    public static class Config {
        public final String displayName;
        public final int price;
        public final float perc;
        public final String desc;
        public final PlayableSound bulletHitSound;
        public final TextureAtlas.AtlasRegion icon;
        public final PlayableSound energyHitSound;
        public final SolItemType itemType;
        public final String code;
        public final Armor example;

        private Config(String displayName, int price, float perc, PlayableSound bulletHitSound, TextureAtlas.AtlasRegion icon, PlayableSound energyHitSound, SolItemType itemType, String code) {
            this.displayName = displayName;
            this.price = price;
            this.perc = perc;
            this.icon = icon;
            this.energyHitSound = energyHitSound;
            this.itemType = itemType;
            this.code = code;
            this.desc = "Reduces damage by " + (int)(perc * 100.0f) + "%\nStrong against energy guns";
            this.bulletHitSound = bulletHitSound;
            this.example = new Armor(this);
        }

        public static void load(String armorName, ItemManager itemManager, OggSoundManager soundManager, SolItemTypes types) {
            JSONObject rootNode = Validator.getValidatedJSON(armorName, "engine:schemaArmor");
            String displayName = rootNode.getString("displayName");
            int price = rootNode.getInt("price");
            float perc = (float)rootNode.getDouble("perc");
            ArrayList<String> bulletDamageSoundUrns = Assets.convertToStringList(rootNode.getJSONArray("bulletHitSounds"));
            ArrayList<String> energyDamageSoundUrns = Assets.convertToStringList(rootNode.getJSONArray("energyHitSounds"));
            float basePitch = (float)rootNode.getDouble("baseSoundPitch");
            OggSoundSet bulletDmgSound = new OggSoundSet(soundManager, bulletDamageSoundUrns, basePitch);
            OggSoundSet energyDmgSound = new OggSoundSet(soundManager, energyDamageSoundUrns, basePitch);
            TextureAtlas.AtlasRegion icon = Assets.getAtlasRegion(armorName + "Icon");
            Config armorConfig = new Config(displayName, price, perc, bulletDmgSound, icon, energyDmgSound, types.armor, armorName);
            itemManager.registerItem(armorConfig.example);
        }
    }
}

