/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.item;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import org.destinationsol.assets.Assets;
import org.destinationsol.assets.json.Validator;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.item.ItemManager;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.item.SolItemType;
import org.destinationsol.game.item.SolItemTypes;
import org.destinationsol.game.projectile.ProjectileConfig;
import org.json.JSONObject;

public class Clip
implements SolItem {
    private final Config config;

    Clip(Config config) {
        this.config = config;
    }

    @Override
    public String getDisplayName() {
        return this.config.displayName;
    }

    @Override
    public float getPrice() {
        return this.config.price;
    }

    @Override
    public String getDescription() {
        return this.config.desc;
    }

    public Config getConfig() {
        return this.config;
    }

    @Override
    public SolItem copy() {
        return new Clip(this.config);
    }

    @Override
    public boolean isSame(SolItem item) {
        return item instanceof Clip && ((Clip)item).config == this.config;
    }

    @Override
    public TextureAtlas.AtlasRegion getIcon(SolGame game) {
        return this.config.icon;
    }

    @Override
    public SolItemType getItemType() {
        return this.config.itemType;
    }

    @Override
    public String getCode() {
        return this.config.code;
    }

    @Override
    public int isEquipped() {
        return 0;
    }

    @Override
    public void setEquipped(int equipped) {
    }

    public static class Config {
        public final int price;
        public final String displayName;
        public final String desc;
        public final int size;
        public final TextureAtlas.AtlasRegion icon;
        public final ProjectileConfig projConfig;
        public final boolean infinite;
        public final int projectilesPerShot;
        public final SolItemType itemType;
        public final String plural;
        public final String code;
        public final Clip example;

        public Config(ProjectileConfig projConfig, boolean infinite, int price, String displayName, int size, String plural, TextureAtlas.AtlasRegion icon, int projectilesPerShot, SolItemType itemType, String code) {
            this.projConfig = projConfig;
            this.infinite = infinite;
            this.price = price;
            this.displayName = displayName;
            this.size = size;
            this.icon = icon;
            this.projectilesPerShot = projectilesPerShot;
            this.itemType = itemType;
            this.plural = plural;
            this.code = code;
            this.desc = size + " " + this.plural;
            this.example = new Clip(this);
        }

        public static void load(String clipName, ItemManager itemManager, SolItemTypes types) {
            JSONObject rootNode = Validator.getValidatedJSON(clipName, "engine:schemaClip");
            String projectileName = rootNode.getString("projectile");
            ProjectileConfig projectileConfig = itemManager.projConfigs.find(projectileName);
            boolean infinite = rootNode.optBoolean("infinite", false);
            int size = rootNode.getInt("size");
            int projectilesPerShot = rootNode.optInt("projectilesPerShot", 1);
            if (projectilesPerShot < 1) {
                throw new AssertionError((Object)("Invalid projectilesPerShot for " + clipName));
            }
            int price = 0;
            String displayName = "";
            String plural = "";
            TextureAtlas.AtlasRegion icon = null;
            if (!infinite) {
                price = rootNode.getInt("price");
                displayName = rootNode.getString("displayName");
                plural = rootNode.getString("plural");
                icon = Assets.getAtlasRegion(clipName + "Icon");
            }
            Config clipConfig = new Config(projectileConfig, infinite, price, displayName, size, plural, icon, projectilesPerShot, types.clip, clipName);
            itemManager.registerItem(clipConfig.example);
        }
    }
}

