/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.item;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import org.destinationsol.assets.json.Validator;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.item.SolItemType;
import org.json.JSONObject;

public class Engine
implements SolItem {
    private final Config config;

    private Engine(Config config) {
        this.config = config;
    }

    @Override
    public String getDisplayName() {
        return this.config.displayName;
    }

    @Override
    public float getPrice() {
        return this.config.price;
    }

    @Override
    public String getDescription() {
        return this.config.description;
    }

    public float getRotationAcceleration() {
        return this.config.rotationAcceleration;
    }

    public float getAcceleration() {
        return this.config.acceleration;
    }

    public float getMaxRotationSpeed() {
        return this.config.maxRotationSpeed;
    }

    public boolean isBig() {
        return this.config.isBig;
    }

    @Override
    public Engine copy() {
        return new Engine(this.config);
    }

    @Override
    public boolean isSame(SolItem item) {
        return item instanceof Engine && ((Engine)item).config == this.config;
    }

    @Override
    public TextureAtlas.AtlasRegion getIcon(SolGame game) {
        return this.config.icon;
    }

    @Override
    public SolItemType getItemType() {
        return null;
    }

    @Override
    public String getCode() {
        return null;
    }

    @Override
    public int isEquipped() {
        return 0;
    }

    @Override
    public void setEquipped(int equipped) {
    }

    public static class Config {
        public final String displayName;
        public final int price;
        public final String description;
        public final float rotationAcceleration;
        public final float acceleration;
        public final float maxRotationSpeed;
        public final boolean isBig;
        public final Engine exampleEngine;
        public final TextureAtlas.AtlasRegion icon;
        public final String code;

        private Config(String displayName, int price, String description, float rotationAcceleration, float acceleration, float maxRotationSpeed, boolean isBig, TextureAtlas.AtlasRegion icon, String code) {
            this.displayName = displayName;
            this.price = price;
            this.description = description;
            this.rotationAcceleration = rotationAcceleration;
            this.acceleration = acceleration;
            this.maxRotationSpeed = maxRotationSpeed;
            this.isBig = isBig;
            this.icon = icon;
            this.code = code;
            this.exampleEngine = new Engine(this);
        }

        public static Config load(String engineName) {
            JSONObject rootNode = Validator.getValidatedJSON(engineName, "engine:schemaEngine");
            boolean isBig = rootNode.getBoolean("big");
            float rotationAcceleration = isBig ? 100.0f : 515.0f;
            float acceleration = 2.0f;
            float maxRotationSpeed = isBig ? 40.0f : 230.0f;
            return new Config(null, 0, null, rotationAcceleration, acceleration, maxRotationSpeed, isBig, null, engineName);
        }
    }
}

