/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.item;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import java.util.ArrayList;
import org.destinationsol.assets.Assets;
import org.destinationsol.assets.json.Validator;
import org.destinationsol.assets.sound.OggSoundManager;
import org.destinationsol.assets.sound.OggSoundSet;
import org.destinationsol.assets.sound.PlayableSound;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.DmgType;
import org.destinationsol.game.HardnessCalc;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.item.Clip;
import org.destinationsol.game.item.ItemManager;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.item.SolItemType;
import org.destinationsol.game.item.SolItemTypes;
import org.destinationsol.game.projectile.ProjectileConfig;
import org.json.JSONObject;

public class Gun
implements SolItem {
    public final Config config;
    public int ammo;
    public float reloadAwait;
    private int myEquipped;

    public Gun(Config config, int ammo, float reloadAwait) {
        this.config = config;
        this.ammo = ammo;
        this.reloadAwait = reloadAwait;
    }

    public Gun(Config config, int ammo, float reloadAwait, int equipped) {
        this(config, ammo, reloadAwait);
        this.myEquipped = equipped;
    }

    @Override
    public String getDisplayName() {
        return this.config.displayName;
    }

    @Override
    public float getPrice() {
        return this.config.price;
    }

    @Override
    public String getDescription() {
        return this.config.desc;
    }

    @Override
    public Gun copy() {
        return new Gun(this.config, this.ammo, this.reloadAwait, this.myEquipped);
    }

    @Override
    public boolean isSame(SolItem item) {
        return false;
    }

    @Override
    public TextureAtlas.AtlasRegion getIcon(SolGame game) {
        return this.config.icon;
    }

    @Override
    public SolItemType getItemType() {
        return this.config.itemType;
    }

    @Override
    public String getCode() {
        return this.config.code;
    }

    public boolean canShoot() {
        return this.ammo > 0 || this.reloadAwait > 0.0f;
    }

    @Override
    public int isEquipped() {
        return this.myEquipped;
    }

    @Override
    public void setEquipped(int equipped) {
        this.myEquipped = equipped;
    }

    public static class Config {
        public final float minAngleVar;
        public final float maxAngleVar;
        public final float angleVarDamp;
        public final float angleVarPerShot;
        public final float timeBetweenShots;
        public final float reloadTime;
        public final float gunLength;
        public final String displayName;
        public final TextureAtlas.AtlasRegion tex;
        public final boolean lightOnShot;
        public final int price;
        public final String desc;
        public final float dps;
        public final Gun example;
        public final Clip.Config clipConf;
        public final PlayableSound shootSound;
        public final PlayableSound reloadSound;
        public final TextureAtlas.AtlasRegion icon;
        public final boolean fixed;
        public final float meanDps;
        public final SolItemType itemType;
        public final float texLenPercentage;
        public final String code;

        public Config(float minAngleVar, float maxAngleVar, float angleVarDamp, float angleVarPerShot, float timeBetweenShots, float reloadTime, float gunLength, String displayName, boolean lightOnShot, int price, Clip.Config clipConf, PlayableSound shootSound, PlayableSound reloadSound, TextureAtlas.AtlasRegion tex, TextureAtlas.AtlasRegion icon, boolean fixed, SolItemType itemType, float texLenPercentage, String code) {
            this.shootSound = shootSound;
            this.reloadSound = reloadSound;
            this.tex = tex;
            this.maxAngleVar = maxAngleVar;
            this.minAngleVar = minAngleVar;
            this.angleVarDamp = angleVarDamp;
            this.angleVarPerShot = angleVarPerShot;
            this.timeBetweenShots = timeBetweenShots;
            this.reloadTime = reloadTime;
            this.gunLength = gunLength;
            this.displayName = displayName;
            this.lightOnShot = lightOnShot;
            this.price = price;
            this.clipConf = clipConf;
            this.icon = icon;
            this.fixed = fixed;
            this.itemType = itemType;
            this.texLenPercentage = texLenPercentage;
            this.code = code;
            this.dps = HardnessCalc.getShotDps(this, clipConf.projConfig.dmg);
            this.meanDps = HardnessCalc.getGunMeanDps(this);
            this.desc = this.makeDesc();
            this.example = new Gun(this, 0, 0.0f);
        }

        public static void load(String gunName, ItemManager itemManager, OggSoundManager soundManager, SolItemTypes types) {
            JSONObject rootNode = Validator.getValidatedJSON(gunName, "engine:schemaGun");
            float minAngleVar = (float)rootNode.optDouble("minAngleVar", 0.0);
            float maxAngleVar = (float)rootNode.getDouble("maxAngleVar");
            float angleVarDamp = (float)rootNode.getDouble("angleVarDamp");
            float angleVarPerShot = (float)rootNode.getDouble("angleVarPerShot");
            float timeBetweenShots = (float)rootNode.getDouble("timeBetweenShots");
            float reloadTime = (float)rootNode.getDouble("reloadTime");
            float gunLength = (float)rootNode.getDouble("gunLength");
            float texLenPercentage = (float)rootNode.optDouble("texLenPerc", 1.0);
            String displayName = rootNode.getString("displayName");
            boolean lightOnShot = rootNode.optBoolean("lightOnShot", false);
            int price = rootNode.getInt("price");
            String clipName = rootNode.getString("clipName");
            ArrayList<String> reloadSoundUrns = Assets.convertToStringList(rootNode.getJSONArray("reloadSounds"));
            OggSoundSet reloadSoundSet = new OggSoundSet(soundManager, reloadSoundUrns, 1.0f);
            ArrayList<String> shootSoundUrns = Assets.convertToStringList(rootNode.getJSONArray("shootSounds"));
            float shootPitch = (float)rootNode.optDouble("shootSoundPitch", 1.0);
            OggSoundSet shootSoundSet = new OggSoundSet(soundManager, shootSoundUrns, shootPitch);
            boolean fixed = rootNode.optBoolean("fixed", false);
            SolItemType itemType = fixed ? types.fixedGun : types.gun;
            Clip.Config clipConf = null;
            if (!clipName.isEmpty()) {
                Clip clip = (Clip)itemManager.getExample(clipName);
                if (clip == null) {
                    Clip.Config.load(clipName, itemManager, types);
                    clip = (Clip)itemManager.getExample(clipName);
                }
                clipConf = clip.getConfig();
            }
            TextureAtlas.AtlasRegion tex = Assets.getAtlasRegion(gunName);
            TextureAtlas.AtlasRegion icon = Assets.getAtlasRegion(gunName + "Icon");
            Config gunConfig = new Config(minAngleVar, maxAngleVar, angleVarDamp, angleVarPerShot, timeBetweenShots, reloadTime, gunLength, displayName, lightOnShot, price, clipConf, shootSoundSet, reloadSoundSet, tex, icon, fixed, itemType, texLenPercentage, gunName);
            itemManager.registerItem(gunConfig.example);
        }

        private String makeDesc() {
            StringBuilder sb = new StringBuilder();
            ProjectileConfig pc = this.clipConf.projConfig;
            sb.append(this.fixed ? "Heavy gun (no rotation)\n" : "Light gun (auto rotation)\n");
            if (pc.dmg > 0.0f) {
                sb.append("Dmg: ").append(SolMath.nice(this.dps)).append("/s\n");
                DmgType dmgType = pc.dmgType;
                if (dmgType == DmgType.ENERGY) {
                    sb.append("Weak against armor\n");
                } else if (dmgType == DmgType.BULLET) {
                    sb.append("Weak against shields\n");
                }
            } else if (pc.emTime > 0.0f) {
                sb.append("Disables enemy ships for ").append(SolMath.nice(pc.emTime)).append(" s\n");
            }
            if (pc.density > 0.0f) {
                sb.append("Knocks enemies back\n");
            }
            sb.append("Reload: ").append(SolMath.nice(this.reloadTime)).append(" s\n");
            if (this.clipConf.infinite) {
                sb.append("Infinite ammo\n");
            } else {
                sb.append("Uses ").append(this.clipConf.plural).append("\n");
            }
            return sb.toString();
        }
    }
}

