/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.item;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.destinationsol.common.SolRandom;
import org.destinationsol.game.item.SolItem;

public class ItemContainer
implements Iterable<List<SolItem>> {
    private static final int MAX_INVENTORY_PAGES = 4;
    private static final int MAX_GROUP_COUNT = 32;
    private static final int MAX_STACK_SIZE = 30;
    private List<List<SolItem>> groups = new ArrayList<List<SolItem>>();
    private Set<List<SolItem>> newGroups = new HashSet<List<SolItem>>();

    public boolean tryConsumeItem(SolItem example) {
        for (List<SolItem> group : this.groups) {
            SolItem item = group.get(0);
            if (!example.isSame(item)) continue;
            this.remove(item);
            return true;
        }
        return false;
    }

    public int count(SolItem example) {
        for (List<SolItem> group : this.groups) {
            SolItem item = group.get(0);
            if (!example.isSame(item)) continue;
            return group.size();
        }
        return 0;
    }

    public boolean canAdd(SolItem example) {
        for (List<SolItem> group : this.groups) {
            SolItem item = group.get(0);
            if (!item.isSame(example)) continue;
            return group.size() < 30;
        }
        return this.groups.size() < 32;
    }

    public void add(SolItem addedItem) {
        if (addedItem == null) {
            throw new AssertionError((Object)"adding null item");
        }
        for (List<SolItem> group : this.groups) {
            SolItem item = group.get(0);
            if (!item.isSame(addedItem)) continue;
            if (group.size() < 30) {
                group.add(addedItem);
            }
            return;
        }
        ArrayList<SolItem> group = new ArrayList<SolItem>();
        group.add(addedItem);
        this.groups.add(0, group);
        this.newGroups.add(group);
    }

    @Override
    public Iterator<List<SolItem>> iterator() {
        return new ItemContainerIterator();
    }

    public int groupCount() {
        return this.groups.size();
    }

    public boolean contains(SolItem item) {
        for (List<SolItem> group : this.groups) {
            if (!group.contains(item)) continue;
            return true;
        }
        return false;
    }

    public void remove(SolItem item) {
        List<SolItem> remGroup = null;
        for (List<SolItem> group : this.groups) {
            boolean removed = group.remove(item);
            if (group.isEmpty()) {
                remGroup = group;
            }
            if (!removed) continue;
            break;
        }
        if (remGroup != null) {
            this.groups.remove(remGroup);
            this.newGroups.remove(remGroup);
        }
    }

    public List<SolItem> getSelectionAfterRemove(List<SolItem> selected) {
        if (selected.size() > 1) {
            return selected;
        }
        int idx = this.groups.indexOf(selected) + 1;
        if (idx <= 0 || idx >= this.groupCount()) {
            return null;
        }
        return this.groups.get(idx);
    }

    public SolItem getRandom() {
        return this.groups.isEmpty() ? null : SolRandom.randomElement(SolRandom.randomElement(this.groups));
    }

    public boolean isNew(List<SolItem> group) {
        return this.newGroups.contains(group);
    }

    public void seen(List<SolItem> group) {
        this.newGroups.remove(group);
    }

    public void markAllAsSeen() {
        this.newGroups.clear();
    }

    public boolean hasNew() {
        return !this.newGroups.isEmpty();
    }

    public int getCount(int groupIdx) {
        return this.groups.get(groupIdx).size();
    }

    public boolean containsGroup(List<SolItem> group) {
        return this.groups.contains(group);
    }

    public List<SolItem> getGroup(int groupIdx) {
        return this.groups.get(groupIdx);
    }

    public void clear() {
        this.groups.clear();
        this.newGroups.clear();
    }

    private class ItemContainerIterator
    implements Iterator<List<SolItem>> {
        int myCur;

        private ItemContainerIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.myCur != ItemContainer.this.groups.size();
        }

        @Override
        public List<SolItem> next() {
            return (List)ItemContainer.this.groups.get(this.myCur++);
        }

        @Override
        public void remove() {
            throw new AssertionError((Object)"tried to remove via item iterator");
        }
    }
}

