/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.item;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.SerializationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.destinationsol.assets.Assets;
import org.destinationsol.assets.sound.OggSoundManager;
import org.destinationsol.common.SolRandom;
import org.destinationsol.game.GameColors;
import org.destinationsol.game.item.AbilityCharge;
import org.destinationsol.game.item.Armor;
import org.destinationsol.game.item.Clip;
import org.destinationsol.game.item.Engine;
import org.destinationsol.game.item.Gun;
import org.destinationsol.game.item.ItemConfig;
import org.destinationsol.game.item.ItemContainer;
import org.destinationsol.game.item.MoneyItem;
import org.destinationsol.game.item.RepairItem;
import org.destinationsol.game.item.Shield;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.item.SolItemType;
import org.destinationsol.game.item.SolItemTypes;
import org.destinationsol.game.particle.EffectTypes;
import org.destinationsol.game.projectile.ProjectileConfigs;

public class ItemManager {
    public final ProjectileConfigs projConfigs;
    public final TextureAtlas.AtlasRegion moneyIcon;
    public final TextureAtlas.AtlasRegion medMoneyIcon;
    public final TextureAtlas.AtlasRegion bigMoneyIcon;
    public final TextureAtlas.AtlasRegion hugeMoneyIcon;
    public final TextureAtlas.AtlasRegion repairIcon;
    private final HashMap<String, SolItem> myM = new HashMap();
    private final ArrayList<SolItem> myL = new ArrayList();
    private final HashMap<String, Engine.Config> engineConfigs = new HashMap();
    private final SolItemTypes myTypes;
    private final RepairItem myRepairExample;
    private final OggSoundManager soundManager;
    private final EffectTypes effectTypes;
    private final GameColors gameColors;

    public ItemManager(OggSoundManager soundManager, EffectTypes effectTypes, GameColors gameColors) {
        this.soundManager = soundManager;
        this.effectTypes = effectTypes;
        this.gameColors = gameColors;
        this.moneyIcon = Assets.getAtlasRegion("engine:iconMoney");
        this.medMoneyIcon = Assets.getAtlasRegion("engine:iconMedMoney");
        this.bigMoneyIcon = Assets.getAtlasRegion("engine:iconBigMoney");
        this.hugeMoneyIcon = Assets.getAtlasRegion("engine:iconHugeMoney");
        this.repairIcon = Assets.getAtlasRegion("engine:iconRepairItem");
        this.myTypes = new SolItemTypes(soundManager, gameColors);
        this.projConfigs = new ProjectileConfigs(soundManager, effectTypes, gameColors);
        this.myRepairExample = new RepairItem(this.myTypes.repair);
        this.myM.put(this.myRepairExample.getCode(), this.myRepairExample);
        this.myL.addAll(this.myM.values());
    }

    public void fillContainer(ItemContainer itemContainer, String items) {
        List<ItemConfig> list = this.parseItems(items);
        for (ItemConfig itemConfig : list) {
            for (int i = 0; i < itemConfig.amount; ++i) {
                if (!SolRandom.test(itemConfig.chance)) continue;
                SolItem item = SolRandom.randomElement(itemConfig.examples).copy();
                itemContainer.add(item);
            }
        }
    }

    public List<ItemConfig> parseItems(String items) {
        ArrayList<ItemConfig> result = new ArrayList<ItemConfig>();
        if (items.isEmpty()) {
            return result;
        }
        for (String rec : items.split(" ")) {
            String[] parts = rec.split("[|]");
            if (parts.length == 0) continue;
            int itemsIndex = 0;
            float chance = 1.0f;
            if (parts.length == 2) {
                chance = Float.parseFloat(parts[0]);
                if (chance <= 0.0f || chance > 1.0f) {
                    throw new AssertionError((Object)"Item chance has to lie between 0 and 1!");
                }
                itemsIndex = 1;
            } else if (parts.length != 1) {
                throw new AssertionError((Object)"Invalid item format!");
            }
            parts = parts[itemsIndex].split("[*]");
            itemsIndex = 0;
            int amt = 1;
            if (parts.length > 1) {
                amt = Integer.parseInt(parts[0]);
                if (amt <= 0) {
                    throw new AssertionError((Object)"Item amount has to be positive!");
                }
                itemsIndex = 1;
            } else if (parts.length != 1) {
                throw new AssertionError((Object)"Invalid item format!");
            }
            String[] itemNames = parts[itemsIndex].split("[+]");
            ArrayList<SolItem> examples = new ArrayList<SolItem>();
            for (String itemName : itemNames) {
                int wasEquipped = 0;
                if (itemName.endsWith("-1")) {
                    wasEquipped = 1;
                    itemName = itemName.substring(0, itemName.length() - 2);
                } else if (itemName.endsWith("-2")) {
                    wasEquipped = 2;
                    itemName = itemName.substring(0, itemName.length() - 2);
                }
                SolItem example = this.getExample(itemName);
                if (example == null) {
                    try {
                        if (itemName.endsWith("Charge")) {
                            AbilityCharge.Config.load(itemName, this, this.myTypes);
                        } else if (itemName.endsWith("Armor")) {
                            Armor.Config.load(itemName, this, this.soundManager, this.myTypes);
                        } else if (itemName.endsWith("Clip")) {
                            Clip.Config.load(itemName, this, this.myTypes);
                        } else if (itemName.endsWith("Shield") || itemName.endsWith("shield")) {
                            Shield.Config.load(itemName, this, this.soundManager, this.myTypes);
                        } else {
                            Gun.Config.load(itemName, this, this.soundManager, this.myTypes);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException("The JSON of " + itemName + " is missing, or has malformed, a required parameter" + e.getMessage().split(":")[1]);
                    }
                    catch (SerializationException e) {
                        throw new SerializationException("The JSON of " + itemName + " has invalid syntax at " + e.getMessage().split(" near")[0].split("on ")[1]);
                    }
                    example = this.getExample(itemName);
                }
                if (example == null) {
                    throw new AssertionError((Object)("Unknown item " + itemName + " @ " + parts[0] + " @ " + rec + " @ " + items));
                }
                SolItem itemCopy = example.copy();
                itemCopy.setEquipped(wasEquipped);
                examples.add(itemCopy);
            }
            if (examples.isEmpty()) {
                throw new AssertionError((Object)("No item specified @ " + parts[0] + " @ " + rec + " @ " + items));
            }
            ItemConfig itemConfig = new ItemConfig(examples, amt, chance);
            result.add(itemConfig);
        }
        return result;
    }

    public SolItem getExample(String name) {
        return this.myM.get(name);
    }

    public Engine.Config getEngineConfig(String engineName) {
        return this.engineConfigs.computeIfAbsent(engineName, engineConfig -> Engine.Config.load(engineConfig));
    }

    public SolItem random() {
        return this.myL.get(SolRandom.randomInt(this.myM.size())).copy();
    }

    public void registerItem(SolItem example) {
        String code = example.getCode();
        SolItem existing = this.getExample(code);
        if (existing != null) {
            throw new AssertionError((Object)("2 item types registered for item code " + code + ":\n" + existing + " and " + example));
        }
        this.myM.put(code, example);
        this.myL.add(example);
    }

    public MoneyItem moneyItem(float amt) {
        SolItemType t = amt == 100.0f ? this.myTypes.bigMoney : (amt == 30.0f ? this.myTypes.medMoney : this.myTypes.money);
        return new MoneyItem(amt, t);
    }

    public RepairItem getRepairExample() {
        return this.myRepairExample;
    }

    public void addAllGuns(ItemContainer ic) {
        for (SolItem i : this.myM.values()) {
            if (!(i instanceof Clip) || ((Clip)i).getConfig().infinite) continue;
            for (int j = 0; j < 8; ++j) {
                ic.add(i.copy());
            }
        }
        for (SolItem i : this.myM.values()) {
            if (!(i instanceof Gun) || !ic.canAdd(i)) continue;
            ic.add(i.copy());
        }
    }

    public List<MoneyItem> moneyToItems(float amount) {
        return this.moneyToItems(amount, 60);
    }

    public List<MoneyItem> moneyToItems(float amount, int maxNoItemsCreated) {
        ArrayList<MoneyItem> items = new ArrayList<MoneyItem>();
        while (amount > 0.0f) {
            float moneyAmount = amount > 1000.0f ? 1000.0f : (amount > 100.0f ? 100.0f : (amount > 30.0f ? 30.0f : amount));
            amount -= moneyAmount;
            items.add(this.moneyItem(moneyAmount));
            if (maxNoItemsCreated == -1 || items.size() != maxNoItemsCreated) continue;
            break;
        }
        return items;
    }
}

