/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.item;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import java.util.List;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.DmgType;
import org.destinationsol.game.FarObject;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.item.MoneyItem;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.particle.LightSource;
import org.destinationsol.game.ship.SolShip;

public class Loot
implements SolObject {
    public static final int MAX_ROT_SPD = 4;
    public static final float MAX_SPD = 0.2f;
    public static final int MAX_LIFE = 6;
    private static final float DURABILITY = 70.0f;
    private static final float PULL_DESIRED_SPD = 1.0f;
    private static final float PULL_FORCE = 0.1f;
    private static final float MAX_OWNER_AWAIT = 4.0f;
    private final SolItem item;
    private final List<Drawable> drawables;
    private final LightSource lightSource;
    private final Vector2 position;
    private final Body body;
    private final float mass;
    private SolShip owner;
    private float ownerAwait;
    private int life;
    private float angle;

    Loot(SolItem item, Body body, int life, List<Drawable> drawables, LightSource ls, SolShip owner) {
        this.body = body;
        this.life = life;
        this.item = item;
        this.drawables = drawables;
        this.lightSource = ls;
        this.owner = owner;
        this.ownerAwait = 4.0f;
        this.position = new Vector2();
        this.mass = this.body.getMass();
        this.setParamsFromBody();
    }

    @Override
    public void update(SolGame game) {
        this.setParamsFromBody();
        this.lightSource.update(true, this.angle, game);
        if (this.ownerAwait > 0.0f) {
            this.ownerAwait -= game.getTimeStep();
            if (this.ownerAwait <= 0.0f) {
                this.owner = null;
            }
        }
        SolShip puller = null;
        float minDist = Float.MAX_VALUE;
        List<SolObject> objs = game.getObjectManager().getObjects();
        for (SolObject o : objs) {
            float dst;
            SolShip ship;
            if (!(o instanceof SolShip) || !(ship = (SolShip)o).getPilot().collectsItems() || !(this.item instanceof MoneyItem) && !ship.getItemContainer().canAdd(this.item) || minDist < (dst = ship.getPosition().dst(this.position))) continue;
            puller = ship;
            minDist = dst;
        }
        if (puller != null) {
            this.maybePulled(puller, puller.getPosition(), puller.getPullDist());
        }
    }

    private void setParamsFromBody() {
        this.position.set(this.body.getPosition());
        this.angle = this.body.getAngle() * 57.295776f;
    }

    @Override
    public boolean shouldBeRemoved(SolGame game) {
        return this.life <= 0;
    }

    @Override
    public void onRemove(SolGame game) {
        this.body.getWorld().destroyBody(this.body);
    }

    @Override
    public void receiveDmg(float dmg, SolGame game, Vector2 position, DmgType dmgType) {
        this.life = (int)((float)this.life - dmg);
        game.getSpecialSounds().playHit(game, this, position, dmgType);
    }

    @Override
    public boolean receivesGravity() {
        return true;
    }

    @Override
    public void receiveForce(Vector2 force, SolGame game, boolean acc) {
        if (acc) {
            force.scl(this.mass);
        }
        this.body.applyForceToCenter(force, true);
    }

    @Override
    public Vector2 getPosition() {
        return this.position;
    }

    @Override
    public FarObject toFarObject() {
        return null;
    }

    @Override
    public List<Drawable> getDrawables() {
        return this.drawables;
    }

    @Override
    public float getAngle() {
        return this.angle;
    }

    @Override
    public Vector2 getVelocity() {
        return null;
    }

    @Override
    public void handleContact(SolObject other, float absImpulse, SolGame game, Vector2 collPos) {
        float dmg = absImpulse / this.mass / 70.0f;
        this.receiveDmg((int)dmg, game, collPos, DmgType.CRASH);
    }

    @Override
    public String toDebugString() {
        return null;
    }

    @Override
    public Boolean isMetal() {
        return true;
    }

    @Override
    public boolean hasBody() {
        return true;
    }

    public void maybePulled(SolShip ship, Vector2 pullerPos, float radius) {
        if (ship == this.owner) {
            return;
        }
        Vector2 toPuller = SolMath.getVec(pullerPos);
        toPuller.sub(this.getPosition());
        float pullerDist = toPuller.len();
        if (0.0f < pullerDist && pullerDist < radius) {
            toPuller.scl(1.0f / pullerDist);
            Vector2 velocity = this.body.getLinearVelocity();
            Vector2 velocityDiff = SolMath.distVec(velocity, toPuller);
            float speedDiff = velocityDiff.len();
            if (speedDiff > 0.0f) {
                velocityDiff.scl(0.1f / speedDiff);
                this.body.applyForceToCenter(velocityDiff, true);
            }
            SolMath.free(velocityDiff);
        }
        SolMath.free(toPuller);
    }

    public SolItem getItem() {
        return this.life > 0 ? this.item : null;
    }

    public void setLife(int life) {
        this.life = life;
    }

    public SolShip getOwner() {
        return this.owner;
    }

    public void pickedUp(SolGame game, SolShip ship) {
        this.life = 0;
        Vector2 velocity = new Vector2(ship.getPosition());
        velocity.sub(this.position);
        float fadeTime = 0.25f;
        velocity.scl(1.0f / fadeTime);
        velocity.add(ship.getVelocity());
        game.getPartMan().blip(game, this.position, this.angle, this.item.getItemType().sz, fadeTime, velocity, this.item.getIcon(game));
        game.getSoundManager().play(game, this.item.getItemType().pickUpSound, null, this);
    }
}

