/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.item;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.physics.box2d.Shape;
import java.util.ArrayList;
import org.destinationsol.common.SolColor;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.drawables.DrawableLevel;
import org.destinationsol.game.drawables.RectSprite;
import org.destinationsol.game.drawables.SpriteManager;
import org.destinationsol.game.item.Loot;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.particle.LightSource;
import org.destinationsol.game.ship.SolShip;

public class LootBuilder {
    public Loot build(SolGame game, Vector2 position, SolItem item, Vector2 velocity, int life, float rotationSpeed, SolShip owner) {
        ArrayList<Drawable> drawables = new ArrayList<Drawable>();
        TextureAtlas.AtlasRegion tex = item.getIcon(game);
        float sz = item.getItemType().sz;
        RectSprite s = SpriteManager.createStaticSprite(tex, sz, 0.0f, 0.0f, new Vector2(), DrawableLevel.GUNS, 0.0f, 0.0f, SolColor.WHITE, false);
        drawables.add(s);
        Body b = this.buildBody(game, position, sz);
        b.setLinearVelocity(velocity);
        b.setAngularVelocity(rotationSpeed);
        Color col = item.getItemType().color;
        LightSource ls = new LightSource(sz + 0.18f, false, 0.5f, new Vector2(), col);
        ls.collectDrawables(drawables);
        Loot loot = new Loot(item, b, life, drawables, ls, owner);
        b.setUserData((Object)loot);
        return loot;
    }

    private Body buildBody(SolGame game, Vector2 position, float sz) {
        BodyDef bd = new BodyDef();
        bd.type = BodyDef.BodyType.DynamicBody;
        bd.angle = 0.0f;
        bd.angularDamping = 0.0f;
        bd.position.set(position);
        bd.linearDamping = 0.0f;
        Body body = game.getObjectManager().getWorld().createBody(bd);
        PolygonShape shape = new PolygonShape();
        shape.setAsBox(sz / 2.0f, sz / 2.0f);
        body.createFixture((Shape)shape, 0.5f);
        shape.dispose();
        return body;
    }
}

