/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.item;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import org.destinationsol.game.ShipConfig;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.item.ShipItem;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.item.SolItemType;
import org.destinationsol.game.ship.SolShip;

public class MercItem
implements SolItem {
    private final ShipConfig config;
    private final String myDesc;
    private SolShip solship;

    public MercItem(ShipConfig config) {
        this.config = config;
        this.myDesc = "Has a shield and repairers\n" + ShipItem.makeDesc(config.hull);
    }

    @Override
    public String getDisplayName() {
        return this.config.hull.getDisplayName();
    }

    @Override
    public float getPrice() {
        return this.config.hull.getHirePrice();
    }

    @Override
    public String getDescription() {
        return this.myDesc;
    }

    @Override
    public SolItem copy() {
        return new MercItem(this.config);
    }

    @Override
    public boolean isSame(SolItem item) {
        return false;
    }

    @Override
    public TextureAtlas.AtlasRegion getIcon(SolGame game) {
        return this.config.hull.getIcon();
    }

    @Override
    public SolItemType getItemType() {
        return ShipItem.EMPTY;
    }

    @Override
    public String getCode() {
        return null;
    }

    @Override
    public int isEquipped() {
        return 0;
    }

    @Override
    public void setEquipped(int equipped) {
    }

    public ShipConfig getConfig() {
        return this.config;
    }

    public void setSolShip(SolShip solship) {
        this.solship = solship;
    }

    public SolShip getSolShip() {
        return this.solship;
    }
}

