/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.item;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.item.ItemManager;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.item.SolItemType;

public class MoneyItem
implements SolItem {
    public static final int SMALL_AMOUNT = 10;
    public static final int MEDIUM_AMOUNT = 30;
    public static final int BIG_AMOUNT = 100;
    public static final int HUGE_AMOUNT = 1000;
    private final float amount;
    private final SolItemType itemType;

    MoneyItem(float amt, SolItemType itemType) {
        this.amount = amt;
        this.itemType = itemType;
    }

    @Override
    public String getDisplayName() {
        return "money";
    }

    @Override
    public float getPrice() {
        return this.amount;
    }

    @Override
    public String getDescription() {
        return "money";
    }

    @Override
    public MoneyItem copy() {
        return new MoneyItem(this.amount, this.itemType);
    }

    @Override
    public boolean isSame(SolItem item) {
        return item instanceof MoneyItem && ((MoneyItem)item).amount == this.amount;
    }

    @Override
    public TextureAtlas.AtlasRegion getIcon(SolGame game) {
        ItemManager im = game.getItemMan();
        if (this.amount == 1000.0f) {
            return im.hugeMoneyIcon;
        }
        if (this.amount == 100.0f) {
            return im.bigMoneyIcon;
        }
        if (this.amount == 30.0f) {
            return im.medMoneyIcon;
        }
        return im.moneyIcon;
    }

    @Override
    public SolItemType getItemType() {
        return this.itemType;
    }

    @Override
    public String getCode() {
        return null;
    }

    @Override
    public int isEquipped() {
        return 0;
    }

    @Override
    public void setEquipped(int equipped) {
    }
}

