/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.item;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import org.destinationsol.assets.Assets;
import org.destinationsol.assets.json.Validator;
import org.destinationsol.assets.sound.OggSound;
import org.destinationsol.assets.sound.OggSoundManager;
import org.destinationsol.assets.sound.PlayableSound;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.DmgType;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.item.ItemManager;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.item.SolItemType;
import org.destinationsol.game.item.SolItemTypes;
import org.destinationsol.game.ship.SolShip;
import org.json.JSONObject;

public class Shield
implements SolItem {
    public static final float SIZE_PERC = 0.7f;
    private final Config config;
    private float myLife;
    private float myIdleTime;
    private int myEquipped;

    private Shield(Config config) {
        this.config = config;
        this.myLife = config.maxLife;
        this.myIdleTime = config.idleTime;
    }

    private Shield(Config config, int equipped) {
        this(config);
        this.myEquipped = equipped;
    }

    public void update(SolGame game, SolObject owner) {
        float ts = game.getTimeStep();
        if (this.myIdleTime >= this.config.idleTime) {
            if (this.myLife < this.config.maxLife) {
                float regen = this.config.regenSpeed * ts;
                this.myLife = SolMath.approach(this.myLife, this.config.maxLife, regen);
            }
        } else {
            this.myIdleTime += ts;
            if (this.myIdleTime >= this.config.idleTime) {
                game.getSoundManager().play(game, this.config.regenSound, null, owner);
            }
        }
    }

    @Override
    public String getDisplayName() {
        return this.config.displayName;
    }

    @Override
    public float getPrice() {
        return this.config.price;
    }

    @Override
    public String getDescription() {
        return this.config.desc;
    }

    @Override
    public SolItem copy() {
        return new Shield(this.config, this.myEquipped);
    }

    @Override
    public boolean isSame(SolItem item) {
        return false;
    }

    @Override
    public TextureAtlas.AtlasRegion getIcon(SolGame game) {
        return this.config.icon;
    }

    @Override
    public SolItemType getItemType() {
        return this.config.itemType;
    }

    @Override
    public String getCode() {
        return this.config.code;
    }

    public float getLife() {
        return this.myLife;
    }

    public float getMaxLife() {
        return this.config.maxLife;
    }

    public boolean canAbsorb(DmgType dmgType) {
        return this.myLife > 0.0f && dmgType != DmgType.FIRE && dmgType != DmgType.CRASH;
    }

    public void absorb(SolGame game, float dmg, Vector2 position, SolShip ship, DmgType dmgType) {
        if (!this.canAbsorb(dmgType) || dmg <= 0.0f) {
            throw new AssertionError((Object)"illegal call to absorb");
        }
        this.myIdleTime = 0.0f;
        if (dmgType == DmgType.BULLET) {
            dmg *= this.config.bulletDmgFactor;
        } else if (dmgType == DmgType.ENERGY) {
            dmg *= this.config.energyDmgFactor;
        } else if (dmgType == DmgType.EXPLOSION) {
            dmg *= this.config.explosionDmgFactor;
        }
        this.myLife -= this.myLife < dmg ? this.myLife : dmg;
        game.getPartMan().shieldSpark(game, position, ship.getHull(), this.config.tex, dmg / this.config.maxLife);
        float volMul = SolMath.clamp(4.0f * dmg / this.config.maxLife);
        game.getSoundManager().play(game, this.config.absorbSound, null, ship, volMul);
    }

    @Override
    public int isEquipped() {
        return this.myEquipped;
    }

    @Override
    public void setEquipped(int equipped) {
        this.myEquipped = equipped;
    }

    public static class Config {
        public final String displayName;
        public final int price;
        public final String desc;
        public final PlayableSound absorbSound;
        public final PlayableSound regenSound;
        public final Shield example;
        public final float maxLife;
        public final float idleTime;
        public final float regenSpeed;
        public final float bulletDmgFactor;
        public final float energyDmgFactor;
        public final float explosionDmgFactor;
        public final TextureAtlas.AtlasRegion icon;
        public final SolItemType itemType;
        public final String code;
        public TextureAtlas.AtlasRegion tex;

        private Config(int maxLife, float idleTime, float regenSpeed, float bulletDmgFactor, float energyDmgFactor, float explosionDmgFactor, String displayName, int price, PlayableSound absorbSound, PlayableSound regenSound, TextureAtlas.AtlasRegion icon, TextureAtlas.AtlasRegion tex, SolItemType itemType, String code) {
            this.maxLife = maxLife;
            this.idleTime = idleTime;
            this.regenSpeed = regenSpeed;
            this.bulletDmgFactor = bulletDmgFactor;
            this.energyDmgFactor = energyDmgFactor;
            this.explosionDmgFactor = explosionDmgFactor;
            this.displayName = displayName;
            this.price = price;
            this.absorbSound = absorbSound;
            this.regenSound = regenSound;
            this.icon = icon;
            this.tex = tex;
            this.itemType = itemType;
            this.code = code;
            this.example = new Shield(this);
            this.desc = this.makeDesc();
        }

        public static void load(String shieldName, ItemManager itemManager, OggSoundManager soundManager, SolItemTypes types) {
            JSONObject rootNode = Validator.getValidatedJSON(shieldName, "engine:schemaShield");
            int maxLife = rootNode.getInt("maxLife");
            float idleTime = (float)rootNode.getDouble("idleTime");
            float regenSpeed = (float)rootNode.getDouble("regenSpd");
            float bulletDmgFactor = (float)rootNode.getDouble("bulletDmgFactor");
            float energyDmgFactor = (float)rootNode.getDouble("energyDmgFactor");
            float explosionDmgFactor = (float)rootNode.getDouble("explosionDmgFactor");
            String displayName = rootNode.getString("displayName");
            int price = rootNode.getInt("price");
            String absorbUrn = rootNode.getString("absorbSound");
            float absorbPitch = (float)rootNode.optDouble("absorbSoundPitch", 1.0);
            OggSound absorbSound = soundManager.getSound(absorbUrn, absorbPitch);
            String regenUrn = rootNode.getString("regenSound");
            OggSound regenSound = soundManager.getSound(regenUrn);
            TextureAtlas.AtlasRegion tex = Assets.getAtlasRegion(shieldName);
            TextureAtlas.AtlasRegion icon = Assets.getAtlasRegion(shieldName + "Icon");
            Config config = new Config(maxLife, idleTime, regenSpeed, bulletDmgFactor, energyDmgFactor, explosionDmgFactor, displayName, price, absorbSound, regenSound, icon, tex, types.shield, shieldName);
            itemManager.registerItem(config.example);
        }

        private String makeDesc() {
            StringBuilder sb = new StringBuilder();
            sb.append("Takes ").append(SolMath.nice(this.maxLife)).append(" dmg\n");
            sb.append("Needs ").append(SolMath.nice(this.idleTime)).append("s to start regeneration\n");
            sb.append("Regenerates ").append(SolMath.nice(this.regenSpeed)).append(" shield points per s\n");
            sb.append("Bullet Dmg resist: ").append(100.0f - this.bulletDmgFactor * 100.0f).append("%\n");
            sb.append("Energy Dmg resist: ").append(100.0f - this.energyDmgFactor * 100.0f).append("%\n");
            sb.append("Explosion Dmg resist: ").append(100.0f - this.explosionDmgFactor * 100.0f).append("%\n");
            return sb.toString();
        }
    }
}

